/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VehicleWheel
implements Savable {
    protected long wheelId = 0L;
    protected boolean frontWheel;
    protected Vector3f location = new Vector3f();
    protected Vector3f direction = new Vector3f();
    protected Vector3f axle = new Vector3f();
    protected float suspensionStiffness = 20.0f;
    protected float wheelsDampingRelaxation = 2.3f;
    protected float wheelsDampingCompression = 4.4f;
    protected float frictionSlip = 10.5f;
    protected float rollInfluence = 1.0f;
    protected float maxSuspensionTravelCm = 500.0f;
    protected float maxSuspensionForce = 6000.0f;
    protected float radius = 0.5f;
    protected float restLength = 1.0f;
    protected Vector3f wheelWorldLocation = new Vector3f();
    protected Quaternion wheelWorldRotation = new Quaternion();
    protected Spatial wheelSpatial;
    protected Matrix3f tmp_Matrix = new Matrix3f();
    protected final Quaternion tmp_inverseWorldRotation = new Quaternion();
    private boolean applyLocal = false;

    public VehicleWheel() {
    }

    public VehicleWheel(Spatial spatial, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f, float f2, boolean bl) {
        this(vector3f, vector3f2, vector3f3, f, f2, bl);
        this.wheelSpatial = spatial;
    }

    public VehicleWheel(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, float f, float f2, boolean bl) {
        this.location.set(vector3f);
        this.direction.set(vector3f2);
        this.axle.set(vector3f3);
        this.frontWheel = bl;
        this.restLength = f;
        this.radius = f2;
    }

    public synchronized void updatePhysicsState() {
        this.getWheelLocation(this.wheelId, this.wheelWorldLocation);
        this.getWheelRotation(this.wheelId, this.tmp_Matrix);
        this.wheelWorldRotation.fromRotationMatrix(this.tmp_Matrix);
    }

    private native void getWheelLocation(long var1, Vector3f var3);

    private native void getWheelRotation(long var1, Matrix3f var3);

    public synchronized void applyWheelTransform() {
        if (this.wheelSpatial == null) {
            return;
        }
        Quaternion quaternion = this.wheelSpatial.getLocalRotation();
        Vector3f vector3f = this.wheelSpatial.getLocalTranslation();
        if (!this.applyLocal && this.wheelSpatial.getParent() != null) {
            vector3f.set(this.wheelWorldLocation).subtractLocal(this.wheelSpatial.getParent().getWorldTranslation());
            vector3f.divideLocal(this.wheelSpatial.getParent().getWorldScale());
            this.tmp_inverseWorldRotation.set(this.wheelSpatial.getParent().getWorldRotation()).inverseLocal().multLocal(vector3f);
            quaternion.set(this.wheelWorldRotation);
            this.tmp_inverseWorldRotation.set(this.wheelSpatial.getParent().getWorldRotation()).inverseLocal().mult(quaternion, quaternion);
            this.wheelSpatial.setLocalTranslation(vector3f);
            this.wheelSpatial.setLocalRotation(quaternion);
        } else {
            this.wheelSpatial.setLocalTranslation(this.wheelWorldLocation);
            this.wheelSpatial.setLocalRotation(this.wheelWorldRotation);
        }
    }

    public long getWheelId() {
        return this.wheelId;
    }

    public void setWheelId(long l) {
        this.wheelId = l;
        this.applyInfo();
    }

    public boolean isFrontWheel() {
        return this.frontWheel;
    }

    public void setFrontWheel(boolean bl) {
        this.frontWheel = bl;
        this.applyInfo();
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public Vector3f getAxle() {
        return this.axle;
    }

    public float getSuspensionStiffness() {
        return this.suspensionStiffness;
    }

    public void setSuspensionStiffness(float f) {
        this.suspensionStiffness = f;
        this.applyInfo();
    }

    public float getWheelsDampingRelaxation() {
        return this.wheelsDampingRelaxation;
    }

    public void setWheelsDampingRelaxation(float f) {
        this.wheelsDampingRelaxation = f;
        this.applyInfo();
    }

    public float getWheelsDampingCompression() {
        return this.wheelsDampingCompression;
    }

    public void setWheelsDampingCompression(float f) {
        this.wheelsDampingCompression = f;
        this.applyInfo();
    }

    public float getFrictionSlip() {
        return this.frictionSlip;
    }

    public void setFrictionSlip(float f) {
        this.frictionSlip = f;
        this.applyInfo();
    }

    public float getRollInfluence() {
        return this.rollInfluence;
    }

    public void setRollInfluence(float f) {
        this.rollInfluence = f;
        this.applyInfo();
    }

    public float getMaxSuspensionTravelCm() {
        return this.maxSuspensionTravelCm;
    }

    public void setMaxSuspensionTravelCm(float f) {
        this.maxSuspensionTravelCm = f;
        this.applyInfo();
    }

    public float getMaxSuspensionForce() {
        return this.maxSuspensionForce;
    }

    public void setMaxSuspensionForce(float f) {
        this.maxSuspensionForce = f;
        this.applyInfo();
    }

    private void applyInfo() {
        if (this.wheelId == 0L) {
            return;
        }
        this.applyInfo(this.wheelId, this.suspensionStiffness, this.wheelsDampingRelaxation, this.wheelsDampingCompression, this.frictionSlip, this.rollInfluence, this.maxSuspensionTravelCm, this.maxSuspensionForce, this.radius, this.frontWheel, this.restLength);
    }

    private native void applyInfo(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, boolean var11, float var12);

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
        this.applyInfo();
    }

    public float getRestLength() {
        return this.restLength;
    }

    public void setRestLength(float f) {
        this.restLength = f;
        this.applyInfo();
    }

    public PhysicsCollisionObject getGroundObject() {
        return null;
    }

    public Vector3f getCollisionLocation(Vector3f vector3f) {
        this.getCollisionLocation(this.wheelId, vector3f);
        return vector3f;
    }

    private native void getCollisionLocation(long var1, Vector3f var3);

    public Vector3f getCollisionLocation() {
        Vector3f vector3f = new Vector3f();
        this.getCollisionLocation(this.wheelId, vector3f);
        return vector3f;
    }

    public Vector3f getCollisionNormal(Vector3f vector3f) {
        this.getCollisionNormal(this.wheelId, vector3f);
        return vector3f;
    }

    private native void getCollisionNormal(long var1, Vector3f var3);

    public Vector3f getCollisionNormal() {
        Vector3f vector3f = new Vector3f();
        this.getCollisionNormal(this.wheelId, vector3f);
        return vector3f;
    }

    public float getSkidInfo() {
        return this.getSkidInfo(this.wheelId);
    }

    public native float getSkidInfo(long var1);

    public void read(JmeImporter jmeImporter) throws IOException {
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.wheelSpatial = (Spatial)inputCapsule.readSavable("wheelSpatial", null);
        this.frontWheel = inputCapsule.readBoolean("frontWheel", false);
        this.location = (Vector3f)inputCapsule.readSavable("wheelLocation", (Savable)new Vector3f());
        this.direction = (Vector3f)inputCapsule.readSavable("wheelDirection", (Savable)new Vector3f());
        this.axle = (Vector3f)inputCapsule.readSavable("wheelAxle", (Savable)new Vector3f());
        this.suspensionStiffness = inputCapsule.readFloat("suspensionStiffness", 20.0f);
        this.wheelsDampingRelaxation = inputCapsule.readFloat("wheelsDampingRelaxation", 2.3f);
        this.wheelsDampingCompression = inputCapsule.readFloat("wheelsDampingCompression", 4.4f);
        this.frictionSlip = inputCapsule.readFloat("frictionSlip", 10.5f);
        this.rollInfluence = inputCapsule.readFloat("rollInfluence", 1.0f);
        this.maxSuspensionTravelCm = inputCapsule.readFloat("maxSuspensionTravelCm", 500.0f);
        this.maxSuspensionForce = inputCapsule.readFloat("maxSuspensionForce", 6000.0f);
        this.radius = inputCapsule.readFloat("wheelRadius", 0.5f);
        this.restLength = inputCapsule.readFloat("restLength", 1.0f);
    }

    public void write(JmeExporter jmeExporter) throws IOException {
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.wheelSpatial, "wheelSpatial", null);
        outputCapsule.write(this.frontWheel, "frontWheel", false);
        outputCapsule.write((Savable)this.location, "wheelLocation", (Savable)new Vector3f());
        outputCapsule.write((Savable)this.direction, "wheelDirection", (Savable)new Vector3f());
        outputCapsule.write((Savable)this.axle, "wheelAxle", (Savable)new Vector3f());
        outputCapsule.write(this.suspensionStiffness, "suspensionStiffness", 20.0f);
        outputCapsule.write(this.wheelsDampingRelaxation, "wheelsDampingRelaxation", 2.3f);
        outputCapsule.write(this.wheelsDampingCompression, "wheelsDampingCompression", 4.4f);
        outputCapsule.write(this.frictionSlip, "frictionSlip", 10.5f);
        outputCapsule.write(this.rollInfluence, "rollInfluence", 1.0f);
        outputCapsule.write(this.maxSuspensionTravelCm, "maxSuspensionTravelCm", 500.0f);
        outputCapsule.write(this.maxSuspensionForce, "maxSuspensionForce", 6000.0f);
        outputCapsule.write(this.radius, "wheelRadius", 0.5f);
        outputCapsule.write(this.restLength, "restLength", 1.0f);
    }

    public Spatial getWheelSpatial() {
        return this.wheelSpatial;
    }

    public void setWheelSpatial(Spatial spatial) {
        this.wheelSpatial = spatial;
    }

    public boolean isApplyLocal() {
        return this.applyLocal;
    }

    public void setApplyLocal(boolean bl) {
        this.applyLocal = bl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Finalizing Wheel {0}", Long.toHexString(this.wheelId));
        this.finalizeNative(this.wheelId);
    }

    private native void finalizeNative(long var1);
}

