/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class AWTLoader
implements AssetLoader {
    public static final ColorModel AWT_RGBA4444 = new DirectColorModel(16, 61440, 3840, 240, 15);
    public static final ColorModel AWT_RGBA5551 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{5, 5, 5, 1}, true, false, 2, 0);

    private byte[] extractImageData(BufferedImage img) {
        DataBuffer buf = img.getRaster().getDataBuffer();
        switch (buf.getDataType()) {
            case 0: {
                DataBufferByte byteBuf = (DataBufferByte)buf;
                return byteBuf.getData();
            }
        }
        return null;
    }

    private void flipImage(byte[] img, int width, int height, int bpp) {
        int scSz = width * bpp / 8;
        byte[] sln = new byte[scSz];
        int y2 = 0;
        for (int y1 = 0; y1 < height / 2; ++y1) {
            y2 = height - y1 - 1;
            System.arraycopy(img, y1 * scSz, sln, 0, scSz);
            System.arraycopy(img, y2 * scSz, img, y1 * scSz, scSz);
            System.arraycopy(sln, 0, img, y2 * scSz, scSz);
        }
    }

    public Image load(BufferedImage img, boolean flipY) {
        int width = img.getWidth();
        int height = img.getHeight();
        switch (img.getType()) {
            case 5: {
                byte[] dataBuf = this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf, width, height, 24);
                }
                ByteBuffer data = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight() * 3);
                data.put(dataBuf);
                return new Image(Image.Format.BGR8, width, height, data);
            }
            case 10: {
                byte[] dataBuf2 = this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf2, width, height, 8);
                }
                ByteBuffer data2 = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight());
                data2.put(dataBuf2);
                return new Image(Image.Format.Luminance8, width, height, data2);
            }
        }
        if (img.getTransparency() == 1) {
            ByteBuffer data = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight() * 3);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int ny = y;
                    if (flipY) {
                        ny = height - y - 1;
                    }
                    int rgb = img.getRGB(x, ny);
                    byte r = (byte)((rgb & 0xFF0000) >> 16);
                    byte g = (byte)((rgb & 0xFF00) >> 8);
                    byte b = (byte)(rgb & 0xFF);
                    data.put(r).put(g).put(b);
                }
            }
            data.flip();
            return new Image(Image.Format.RGB8, width, height, data);
        }
        ByteBuffer data = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight() * 4);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int ny = y;
                if (flipY) {
                    ny = height - y - 1;
                }
                int rgb = img.getRGB(x, ny);
                byte a = (byte)((rgb & 0xFF000000) >> 24);
                byte r = (byte)((rgb & 0xFF0000) >> 16);
                byte g = (byte)((rgb & 0xFF00) >> 8);
                byte b = (byte)(rgb & 0xFF);
                data.put(r).put(g).put(b).put(a);
            }
        }
        data.flip();
        return new Image(Image.Format.RGBA8, width, height, data);
    }

    public Image load(InputStream in, boolean flipY) throws IOException {
        ImageIO.setUseCache(false);
        BufferedImage img = ImageIO.read(in);
        if (img == null) {
            return null;
        }
        return this.load(img, flipY);
    }

    public Object load(AssetInfo info) throws IOException {
        if (ImageIO.getImageWritersBySuffix(info.getKey().getExtension()) != null) {
            InputStream in = info.openStream();
            boolean flip = ((TextureKey)info.getKey()).isFlipY();
            Image img = this.load(in, flip);
            in.close();
            return img;
        }
        return null;
    }
}

