/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.lights;

import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LightHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(LightHelper.class.getName());

    public LightHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Light toLight(Structure structure, DataRepository dataRepository) throws BlenderFileException {
        Light result = (Light)dataRepository.getLoadedFeature(structure.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        int type = ((Number)structure.getFieldValue("type")).intValue();
        switch (type) {
            case 0: {
                result = new PointLight();
                float distance = ((Number)structure.getFieldValue("dist")).floatValue();
                ((PointLight)result).setRadius(distance);
                break;
            }
            case 1: {
                LOGGER.log(Level.WARNING, "'Sun' lamp is not supported in jMonkeyEngine.");
                break;
            }
            case 2: {
                result = new SpotLight();
                ((SpotLight)result).setSpotRange(((Number)structure.getFieldValue("dist")).floatValue());
                float outerAngle = ((Number)structure.getFieldValue("spotsize")).floatValue() * ((float)Math.PI / 180);
                ((SpotLight)result).setSpotOuterAngle(outerAngle);
                float spotblend = ((Number)structure.getFieldValue("spotblend")).floatValue();
                if (spotblend > 1.0f) {
                    spotblend = 1.0f;
                }
                if (spotblend < 0.0f) {
                    spotblend = 0.0f;
                }
                float innerAngle = 2.0f * (float)Math.atan((double)(1.0f - spotblend) * Math.tan(spotblend / 2.0f));
                ((SpotLight)result).setSpotInnerAngle(innerAngle);
                break;
            }
            case 3: {
                LOGGER.log(Level.WARNING, "'Hemi' lamp is not supported in jMonkeyEngine.");
                break;
            }
            case 4: {
                result = new DirectionalLight();
                break;
            }
            default: {
                throw new BlenderFileException("Unknown light source type: " + type);
            }
        }
        if (result != null) {
            float r = ((Number)structure.getFieldValue("r")).floatValue();
            float g = ((Number)structure.getFieldValue("g")).floatValue();
            float b = ((Number)structure.getFieldValue("b")).floatValue();
            result.setColor(new ColorRGBA(r, g, b, 1.0f));
        }
        return result;
    }

    public boolean shouldBeLoaded(Structure structure, DataRepository dataRepository) {
        return (dataRepository.getBlenderKey().getFeaturesToLoad() & 0x10) != 0;
    }
}

