/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.Client;
import com.jme3.network.connection.Connection;
import com.jme3.network.connection.TCPConnection;
import com.jme3.network.connection.UDPConnection;
import com.jme3.network.events.ConnectionListener;
import com.jme3.network.events.MessageAdapter;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientManager
extends MessageAdapter
implements ConnectionListener {
    protected Logger log = Logger.getLogger(ClientManager.class.getName());
    private ArrayList<Client> clients = new ArrayList();
    private Hashtable<Integer, Client> clientsByClientID = new Hashtable();
    private ArrayList<ClientRegistrationMessage> pendingMessages = new ArrayList();
    private ArrayList<ConnectionListener> connectionListeners = new ArrayList();

    private ClientRegistrationMessage findMessage(long playerId) {
        for (ClientRegistrationMessage message : this.pendingMessages) {
            if (message.getId() != playerId) continue;
            return message;
        }
        return null;
    }

    public List<Client> getConnectors() {
        return Collections.unmodifiableList(this.clients);
    }

    public Client getClient(long playerId) {
        for (Client client : this.clients) {
            if (client.getPlayerID() != playerId) continue;
            return client;
        }
        return null;
    }

    public Client getClientByClientID(int clientID) {
        return this.clientsByClientID.get(clientID);
    }

    public boolean isClientConnected(Client client) {
        return this.clients.contains(client);
    }

    @Override
    public void messageReceived(Message message) {
        ClientRegistrationMessage regMessage = (ClientRegistrationMessage)message;
        ClientRegistrationMessage existingMessage = this.findMessage(regMessage.getId());
        if (existingMessage == null) {
            this.pendingMessages.add(regMessage);
            return;
        }
        Client client = new Client(true);
        Connection conOne = regMessage.getConnection();
        Connection conTwo = existingMessage.getConnection();
        if (conOne instanceof TCPConnection) {
            this.fillInTCPInfo(client, regMessage);
        } else if (conOne instanceof UDPConnection) {
            this.fillInUDPInfo(client, regMessage);
        }
        if (conTwo instanceof TCPConnection) {
            this.fillInTCPInfo(client, existingMessage);
        } else if (conTwo instanceof UDPConnection) {
            this.fillInUDPInfo(client, existingMessage);
        }
        if (client.getUDPConnection() == null || client.getTCPConnection() == null) {
            this.log.severe("[ClientManager][???] Something went wrong in the client registration process.");
            return;
        }
        client.setPlayerID(regMessage.getId());
        regMessage.getClient().setPlayerID(regMessage.getId());
        existingMessage.getClient().setPlayerID(regMessage.getId());
        this.fireClientConnected(client);
        this.pendingMessages.remove(existingMessage);
        this.clients.add(client);
        this.clientsByClientID.put(client.getClientID(), client);
    }

    private void fillInUDPInfo(Client client, ClientRegistrationMessage msg) {
        client.setUDPConnection((UDPConnection)msg.getConnection());
        client.setDatagramReceiver(msg.getClient().getDatagramReceiver());
        client.setDatagramChannel(msg.getClient().getDatagramChannel());
        client.getDatagramChannel().keyFor(msg.getConnection().selector).attach(client);
    }

    private void fillInTCPInfo(Client client, ClientRegistrationMessage msg) {
        client.setSocketChannel(msg.getClient().getSocketChannel());
        client.setTCPConnection((TCPConnection)msg.getConnection());
        client.getSocketChannel().keyFor(msg.getConnection().selector).attach(client);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    @Override
    public void clientConnected(Client client) {
    }

    @Override
    public void clientDisconnected(Client client) {
        if (this.clients.contains(client)) {
            this.clients.remove(client);
            this.fireClientDisconnected(client);
        }
    }

    public void fireClientConnected(Client client) {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.clientConnected(client);
        }
    }

    public void fireClientDisconnected(Client client) {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.clientDisconnected(client);
        }
    }
}

