/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RingBuffer<Item>
implements Iterable<Item> {
    private Item[] buffer;
    private int count = 0;
    private int indexOut = 0;
    private int indexIn = 0;

    public RingBuffer(int capacity) {
        this.buffer = new Object[capacity];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public void push(Item item) {
        if (this.count == this.buffer.length) {
            throw new RuntimeException("Ring buffer overflow");
        }
        this.buffer[this.indexIn] = item;
        this.indexIn = (this.indexIn + 1) % this.buffer.length;
        ++this.count;
    }

    public Item pop() {
        if (this.isEmpty()) {
            throw new RuntimeException("Ring buffer underflow");
        }
        Item item = this.buffer[this.indexOut];
        this.buffer[this.indexOut] = null;
        --this.count;
        this.indexOut = (this.indexOut + 1) % this.buffer.length;
        return item;
    }

    @Override
    public Iterator<Item> iterator() {
        return new RingBufferIterator();
    }

    private class RingBufferIterator
    implements Iterator<Item> {
        private int i = 0;

        private RingBufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < RingBuffer.this.count;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return RingBuffer.this.buffer[this.i++];
        }
    }
}

