/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.control.UpdateControl;
import com.jme3.terrain.geomipmap.LRUCache;
import com.jme3.terrain.geomipmap.TerrainGridListener;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.lodcalc.LodCalculatorFactory;
import com.jme3.terrain.geomipmap.lodcalc.LodDistanceCalculatorFactory;
import com.jme3.terrain.heightmap.HeightMap;
import com.jme3.terrain.heightmap.HeightMapGrid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainGrid
extends TerrainQuad {
    protected static final Logger log = Logger.getLogger(TerrainGrid.class.getCanonicalName());
    protected Vector3f currentCell;
    protected int quarterSize;
    protected int quadSize;
    protected HeightMapGrid heightMapGrid;
    protected Vector3f[] quadIndex;
    protected Map<String, TerrainGridListener> listeners = new HashMap<String, TerrainGridListener>();
    protected Material material;
    protected LRUCache<Vector3f, TerrainQuad> cache = new LRUCache(16);
    protected RigidBodyControl[] quadControls;
    protected PhysicsSpace space;

    protected boolean isCenter(int quadIndex) {
        return quadIndex == 9 || quadIndex == 5 || quadIndex == 10 || quadIndex == 6;
    }

    protected int getQuadrant(int quadIndex) {
        if (quadIndex == 9) {
            return 1;
        }
        if (quadIndex == 5) {
            return 2;
        }
        if (quadIndex == 10) {
            return 3;
        }
        if (quadIndex == 6) {
            return 4;
        }
        return 0;
    }

    public TerrainGrid(String name, int patchSize, int maxVisibleSize, Vector3f scale, HeightMapGrid heightMapGrid, Vector2f offset, float offsetAmount, LodCalculatorFactory lodCalculatorFactory) {
        this.name = name;
        this.patchSize = patchSize;
        this.size = maxVisibleSize;
        this.quarterSize = maxVisibleSize >> 2;
        this.quadSize = maxVisibleSize + 1 >> 1;
        this.stepScale = scale;
        this.heightMapGrid = heightMapGrid;
        heightMapGrid.setSize(this.quadSize);
        this.totalSize = maxVisibleSize;
        this.offset = offset;
        this.offsetAmount = offsetAmount;
        this.lodCalculatorFactory = lodCalculatorFactory;
        if (lodCalculatorFactory == null) {
            lodCalculatorFactory = new LodDistanceCalculatorFactory();
        }
        this.quadIndex = new Vector3f[]{new Vector3f(-1.0f, 0.0f, 2.0f), new Vector3f(0.0f, 0.0f, 2.0f), new Vector3f(1.0f, 0.0f, 2.0f), new Vector3f(2.0f, 0.0f, 2.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(2.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(2.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, -1.0f), new Vector3f(-2.0f, 0.0f, -1.0f)};
        this.addControl(new UpdateControl());
    }

    public TerrainGrid(String name, int patchSize, int maxVisibleSize, Vector3f scale, HeightMapGrid heightMapGrid, LodCalculatorFactory lodCalculatorFactory) {
        this(name, patchSize, maxVisibleSize, scale, heightMapGrid, new Vector2f(), 0.0f, lodCalculatorFactory);
    }

    public TerrainGrid(String name, int patchSize, int maxVisibleSize, HeightMapGrid heightMapGrid, LodCalculatorFactory lodCalculatorFactory) {
        this(name, patchSize, maxVisibleSize, Vector3f.UNIT_XYZ, heightMapGrid, lodCalculatorFactory);
    }

    public TerrainGrid(String name, int patchSize, int maxVisibleSize, HeightMapGrid heightMapGrid) {
        this(name, patchSize, maxVisibleSize, heightMapGrid, null);
    }

    public TerrainGrid() {
    }

    public void initialize(Vector3f location) {
        if (this.material == null) {
            throw new RuntimeException("Material must be set prior to call of initialize");
        }
        Vector3f camCell = this.getCell(location);
        this.updateChildrens(camCell);
        for (TerrainGridListener l : this.listeners.values()) {
            l.gridMoved(camCell);
        }
    }

    @Override
    public void update(List<Vector3f> locations) {
        Vector3f cam = locations.get(0);
        Vector3f camCell = this.getCell(cam);
        if (camCell.x != this.currentCell.x || camCell.z != this.currentCell.z) {
            this.updateChildrens(camCell);
            for (TerrainGridListener l : this.listeners.values()) {
                l.gridMoved(camCell);
            }
        }
        super.update(locations);
    }

    public Vector3f getCell(Vector3f location) {
        Vector3f v = location.clone().divideLocal(this.getLocalScale().mult(this.quadSize - 1)).add(0.5f, 0.0f, 0.5f);
        return new Vector3f(FastMath.floor(v.x), 0.0f, FastMath.floor(v.z));
    }

    protected void removeQuad(int idx) {
        if (this.getQuad(idx) != null) {
            if (this.quadControls != null) {
                this.getQuad(idx).removeControl(RigidBodyControl.class);
            }
            for (TerrainGridListener l : this.listeners.values()) {
                l.tileDetached(this.getCell(this.getQuad(idx).getWorldTranslation()), this.getQuad(idx));
            }
            this.detachChild(this.getQuad(idx));
        }
    }

    protected void attachQuadAt(TerrainQuad q, int quadrant, Vector3f cam) {
        this.removeQuad(quadrant);
        q.setQuadrant((short)quadrant);
        this.attachChild(q);
        Vector3f loc = cam.mult(this.quadSize - 1).subtract(this.quarterSize, 0.0f, this.quarterSize);
        q.setLocalTranslation(loc);
        for (TerrainGridListener l : this.listeners.values()) {
            l.tileAttached(cam, q);
        }
        this.updateModelBound();
    }

    protected void updateChildrens(Vector3f cam) {
        int dx = 0;
        int dy = 0;
        if (this.currentCell != null) {
            dx = (int)(cam.x - this.currentCell.x);
            dy = (int)(cam.z - this.currentCell.z);
        }
        int kxm = 0;
        int kxM = 4;
        int kym = 0;
        int kyM = 4;
        if (dx == -1) {
            kxM = 3;
        } else if (dx == 1) {
            kxm = 1;
        }
        if (dy == -1) {
            kyM = 3;
        } else if (dy == 1) {
            kym = 1;
        }
        for (int i = kym; i < kyM; ++i) {
            for (int j = kxm; j < kxM; ++j) {
                this.cache.get(cam.add(this.quadIndex[i * 4 + j]));
            }
        }
        if (this.executor == null) {
            this.executor = this.createExecutorService();
        }
        this.executor.submit(new UpdateQuadCache(cam));
        this.currentCell = cam;
    }

    public void addListener(String id, TerrainGridListener listener) {
        this.listeners.put(id, listener);
    }

    public Vector3f getCurrentCell() {
        return this.currentCell;
    }

    public void removeListener(String id) {
        this.listeners.remove(id);
    }

    @Override
    public void setMaterial(Material mat) {
        this.material = mat;
        super.setMaterial(mat);
    }

    public void setQuadSize(int quadSize) {
        this.quadSize = quadSize;
    }

    @Override
    public void adjustHeight(List<Vector2f> xz, List<Float> height) {
        Vector3f currentGridLocation = this.getCurrentCell().mult(this.getLocalScale()).multLocal(this.quadSize - 1);
        for (Vector2f vect : xz) {
            vect.x -= currentGridLocation.x;
            vect.y -= currentGridLocation.z;
        }
        super.adjustHeight(xz, height);
    }

    @Override
    protected TerrainQuad findDownQuad() {
        if (this.quadrant == 1) {
            return this.cache.get(this.currentCell.add(this.quadIndex[13]));
        }
        if (this.quadrant == 3) {
            return this.cache.get(this.currentCell.add(this.quadIndex[14]));
        }
        return null;
    }

    @Override
    protected TerrainQuad findLeftQuad() {
        if (this.quadrant == 1) {
            return this.cache.get(this.currentCell.add(this.quadIndex[8]));
        }
        if (this.quadrant == 2) {
            return this.cache.get(this.currentCell.add(this.quadIndex[4]));
        }
        return null;
    }

    @Override
    protected TerrainQuad findRightQuad() {
        if (this.quadrant == 3) {
            return this.cache.get(this.currentCell.add(this.quadIndex[11]));
        }
        if (this.quadrant == 4) {
            return this.cache.get(this.currentCell.add(this.quadIndex[7]));
        }
        return null;
    }

    @Override
    protected TerrainQuad findTopQuad() {
        if (this.quadrant == 2) {
            return this.cache.get(this.currentCell.add(this.quadIndex[1]));
        }
        if (this.quadrant == 4) {
            return this.cache.get(this.currentCell.add(this.quadIndex[2]));
        }
        return null;
    }

    protected class UpdateQuadCache
    implements Runnable {
        protected final Vector3f location;

        public UpdateQuadCache(Vector3f location) {
            this.location = location;
        }

        public void run() {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int quadIdx = i * 4 + j;
                    final Vector3f temp = this.location.add(TerrainGrid.this.quadIndex[quadIdx]);
                    TerrainQuad q = TerrainGrid.this.cache.get(temp);
                    if (q == null) {
                        HeightMap heightMapAt = TerrainGrid.this.heightMapGrid.getHeightMapAt(temp);
                        q = new TerrainQuad(TerrainGrid.this.getName() + "Quad" + temp, TerrainGrid.this.patchSize, TerrainGrid.this.quadSize, TerrainGrid.this.totalSize, heightMapAt == null ? null : heightMapAt.getHeightMap(), TerrainGrid.this.lodCalculatorFactory);
                        q.setMaterial(TerrainGrid.this.material.clone());
                        log.log(Level.FINE, "Loaded TerrainQuad {0}", q.getName());
                    }
                    TerrainGrid.this.cache.put(temp, q);
                    if (!TerrainGrid.this.isCenter(quadIdx)) continue;
                    final int quadrant = TerrainGrid.this.getQuadrant(quadIdx);
                    final TerrainQuad newQuad = q;
                    TerrainGrid.this.getControl(UpdateControl.class).enqueue(new Callable(){

                        public Object call() throws Exception {
                            TerrainGrid.this.attachQuadAt(newQuad, quadrant, temp);
                            return null;
                        }
                    });
                }
            }
        }
    }
}

