/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class TextureGeneratorBlend
extends TextureGenerator {
    public TextureGeneratorBlend(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, DataRepository dataRepository) {
        int flag = ((Number)tex.getFieldValue("flag")).intValue();
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float dDelta = 1.0f / (float)depth;
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        int halfW = width;
        int halfH = height;
        int halfD = depth;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        Image.Format format = colorBand != null ? Image.Format.RGB8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 3 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer((width <<= 1) * (height <<= 1) * (depth <<= 1) * bytesPerPixel);
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                for (int k = -halfD; k < halfD; ++k) {
                    float y;
                    float x;
                    texvec[2] = dDelta * (float)k;
                    if ((flag & 2) != 0) {
                        x = texvec[1];
                        y = texvec[0];
                    } else {
                        x = texvec[0];
                        y = texvec[1];
                    }
                    if (stype == 0) {
                        texres.tin = (1.0f + x) / 2.0f;
                    } else if (stype == 1) {
                        texres.tin = (1.0f + x) / 2.0f;
                        texres.tin = texres.tin < 0.0f ? 0.0f : (texres.tin *= texres.tin);
                    } else if (stype == 2) {
                        texres.tin = (1.0f + x) / 2.0f;
                        if (texres.tin <= 0.0f) {
                            texres.tin = 0.0f;
                        } else if (texres.tin >= 1.0f) {
                            texres.tin = 1.0f;
                        } else {
                            float t = texres.tin * texres.tin;
                            texres.tin = 3.0f * t - 2.0f * t * texres.tin;
                        }
                    } else if (stype == 3) {
                        texres.tin = (2.0f + x + y) / 4.0f;
                    } else if (stype == 6) {
                        texres.tin = (float)Math.atan2(y, x) / ((float)Math.PI * 2) + 0.5f;
                    } else {
                        texres.tin = 1.0f - (float)Math.sqrt(x * x + y * y + texvec[2] * texvec[2]);
                        if (texres.tin < 0.0f) {
                            texres.tin = 0.0f;
                        }
                        if (stype == 5) {
                            texres.tin *= texres.tin;
                        }
                    }
                    if (colorBand != null) {
                        this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                        this.noiseGenerator.brightnesAndContrastRGB(tex, texres);
                        data.put((byte)(texres.tr * 255.0f));
                        data.put((byte)(texres.tg * 255.0f));
                        data.put((byte)(texres.tb * 255.0f));
                        continue;
                    }
                    this.noiseGenerator.brightnesAndContrast(texres, contrast, brightness);
                    data.put((byte)(texres.tin * 255.0f));
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(data);
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }
}

