/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

class ConstraintShrinkWrap
extends Constraint {
    private static final Logger LOGGER = Logger.getLogger(ConstraintShrinkWrap.class.getName());

    public ConstraintShrinkWrap(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, DataRepository dataRepository) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, dataRepository);
    }

    public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation) {
        ArrayList<Vector3f> pts = new ArrayList<Vector3f>();
        try {
            Node node = (Node)this.getTarget(DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
            for (Spatial spatial : node.getChildren()) {
                if (!(spatial instanceof Geometry)) continue;
                Mesh mesh = ((Geometry)spatial).getMesh();
                FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
                for (int i = 0; i < floatBuffer.limit(); i += 3) {
                    pts.add(new Vector3f(floatBuffer.get(i), floatBuffer.get(i + 1), floatBuffer.get(i + 2)));
                }
            }
            BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation);
            if (boneTrack != null) {
                Vector3f[] translations = boneTrack.getTranslations();
                Quaternion[] rotations = boneTrack.getRotations();
                int maxFrames = translations.length;
                for (int frame = 0; frame < maxFrames; ++frame) {
                    Vector3f currentTranslation = translations[frame];
                    Vector3f minDistancePoint = null;
                    float distance = Float.MAX_VALUE;
                    for (Vector3f p : pts) {
                        float temp = currentTranslation.distance(p);
                        if (!(temp < distance)) continue;
                        distance = temp;
                        minDistancePoint = p;
                    }
                    translations[frame] = minDistancePoint.clone();
                }
                boneTrack.setKeyframes(boneTrack.getTimes(), translations, rotations, boneTrack.getScales());
            }
        }
        catch (BlenderFileException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_SHRINKWRAP;
    }
}

