/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;

public class SkeletonPoints
extends Mesh {
    private Skeleton skeleton;

    public SkeletonPoints(Skeleton skeleton) {
        this.skeleton = skeleton;
        this.setMode(Mesh.Mode.Points);
        VertexBuffer pb = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer fpb = BufferUtils.createFloatBuffer(skeleton.getBoneCount() * 3);
        pb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, fpb);
        this.setBuffer(pb);
        this.setPointSize(7.0f);
        this.updateCounts();
    }

    public void updateGeometry() {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer posBuf = this.getFloatBuffer(VertexBuffer.Type.Position);
        posBuf.clear();
        for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
            Bone bone = this.skeleton.getBone(i);
            Vector3f bonePos = bone.getModelSpacePosition();
            posBuf.put(bonePos.getX()).put(bonePos.getY()).put(bonePos.getZ());
        }
        posBuf.flip();
        vb.updateData(posBuf);
        this.updateBound();
    }
}

