/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.shader.VarType;
import java.io.IOException;

public class RadialBlurFilter
extends Filter {
    private float sampleDist = 1.0f;
    private float sampleStrength = 2.2f;
    private float[] samples = new float[]{-0.08f, -0.05f, -0.03f, -0.02f, -0.01f, 0.01f, 0.02f, 0.03f, 0.05f, 0.08f};

    public RadialBlurFilter() {
        super("Radial blur");
    }

    public RadialBlurFilter(float sampleDist, float sampleStrength) {
        this();
        this.sampleDist = sampleDist;
        this.sampleStrength = sampleStrength;
    }

    protected Material getMaterial() {
        this.material.setFloat("SampleDist", this.sampleDist);
        this.material.setFloat("SampleStrength", this.sampleStrength);
        this.material.setParam("Samples", VarType.FloatArray, this.samples);
        return this.material;
    }

    public float getSampleDistance() {
        return this.sampleDist;
    }

    public void setSampleDistance(float sampleDist) {
        this.sampleDist = sampleDist;
    }

    @Deprecated
    public float getSampleDist() {
        return this.sampleDist;
    }

    @Deprecated
    public void setSampleDist(float sampleDist) {
        this.sampleDist = sampleDist;
    }

    public float getSampleStrength() {
        return this.sampleStrength;
    }

    public void setSampleStrength(float sampleStrength) {
        this.sampleStrength = sampleStrength;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Blur/RadialBlur.j3md");
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.sampleDist, "sampleDist", 1.0f);
        oc.write(this.sampleStrength, "sampleStrength", 2.2f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.sampleDist = ic.readFloat("sampleDist", 1.0f);
        this.sampleStrength = ic.readFloat("sampleStrength", 2.2f);
    }
}

