/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioContext;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioParam;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.Filter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.io.IOException;

public class AudioNode
extends Node {
    protected boolean loop = false;
    protected float volume = 1.0f;
    protected float pitch = 1.0f;
    protected float timeOffset = 0.0f;
    protected Filter dryFilter;
    protected AudioKey key;
    protected transient AudioData data = null;
    protected volatile transient Status status = Status.Stopped;
    protected volatile transient int channel = -1;
    protected Vector3f velocity = new Vector3f();
    protected boolean reverbEnabled = true;
    protected float maxDistance = 200.0f;
    protected float refDistance = 10.0f;
    protected Filter reverbFilter;
    private boolean directional = false;
    protected Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    protected float innerAngle = 360.0f;
    protected float outerAngle = 360.0f;
    protected boolean positional = true;

    public AudioNode() {
    }

    public AudioNode(AudioRenderer audioRenderer) {
    }

    public AudioNode(AudioRenderer audioRenderer, AudioData audioData, AudioKey key) {
        this.setAudioData(audioData, key);
    }

    public AudioNode(AudioData audioData, AudioKey key) {
        this.setAudioData(audioData, key);
    }

    public AudioNode(AudioRenderer audioRenderer, AssetManager assetManager, String name, boolean stream, boolean streamCache) {
        this.key = new AudioKey(name, stream, streamCache);
        this.data = assetManager.loadAsset(this.key);
    }

    public AudioNode(AssetManager assetManager, String name, boolean stream, boolean streamCache) {
        this.key = new AudioKey(name, stream, streamCache);
        this.data = assetManager.loadAsset(this.key);
    }

    public AudioNode(AudioRenderer audioRenderer, AssetManager assetManager, String name, boolean stream) {
        this(audioRenderer, assetManager, name, stream, false);
    }

    public AudioNode(AssetManager assetManager, String name, boolean stream) {
        this(assetManager, name, stream, false);
    }

    public AudioNode(AudioRenderer audioRenderer, AssetManager assetManager, String name) {
        this(assetManager, name, false);
    }

    public AudioNode(AssetManager assetManager, String name) {
        this(assetManager, name, false);
    }

    protected AudioRenderer getRenderer() {
        AudioRenderer result = AudioContext.getAudioRenderer();
        if (result == null) {
            throw new IllegalStateException("No audio renderer available, make sure call is being performed on render thread.");
        }
        return result;
    }

    public void play() {
        this.getRenderer().playSource(this);
    }

    public void playInstance() {
        this.getRenderer().playSourceInstance(this);
    }

    public void stop() {
        this.getRenderer().stopSource(this);
    }

    public final void setChannel(int channel) {
        if (this.status != Status.Stopped) {
            throw new IllegalStateException("Can only set source id when stopped");
        }
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    public Filter getDryFilter() {
        return this.dryFilter;
    }

    public void setDryFilter(Filter dryFilter) {
        this.dryFilter = dryFilter;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.DryFilter);
        }
    }

    public void setAudioData(AudioData audioData, AudioKey key) {
        if (this.data != null) {
            throw new IllegalStateException("Cannot change data once its set");
        }
        this.data = audioData;
        this.key = key;
    }

    public AudioData getAudioData() {
        return this.data;
    }

    public Status getStatus() {
        return this.status;
    }

    public final void setStatus(Status status) {
        this.status = status;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public void setLooping(boolean loop) {
        this.loop = loop;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.Looping);
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        if (pitch < 0.5f || pitch > 2.0f) {
            throw new IllegalArgumentException("Pitch must be between 0.5 and 2.0");
        }
        this.pitch = pitch;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.Pitch);
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            throw new IllegalArgumentException("Volume cannot be negative");
        }
        this.volume = volume;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.Volume);
        }
    }

    public float getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(float timeOffset) {
        if (timeOffset < 0.0f) {
            throw new IllegalArgumentException("Time offset cannot be negative");
        }
        this.timeOffset = timeOffset;
    }

    public Vector3f getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3f velocity) {
        this.velocity.set(velocity);
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.Velocity);
        }
    }

    public boolean isReverbEnabled() {
        return this.reverbEnabled;
    }

    public void setReverbEnabled(boolean reverbEnabled) {
        this.reverbEnabled = reverbEnabled;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.ReverbEnabled);
        }
    }

    public Filter getReverbFilter() {
        return this.reverbFilter;
    }

    public void setReverbFilter(Filter reverbFilter) {
        this.reverbFilter = reverbFilter;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.ReverbFilter);
        }
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        if (maxDistance < 0.0f) {
            throw new IllegalArgumentException("Max distance cannot be negative");
        }
        this.maxDistance = maxDistance;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.MaxDistance);
        }
    }

    public float getRefDistance() {
        return this.refDistance;
    }

    public void setRefDistance(float refDistance) {
        if (refDistance < 0.0f) {
            throw new IllegalArgumentException("Reference distance cannot be negative");
        }
        this.refDistance = refDistance;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.RefDistance);
        }
    }

    public boolean isDirectional() {
        return this.directional;
    }

    public void setDirectional(boolean directional) {
        this.directional = directional;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.IsDirectional);
        }
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction = direction;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.Direction);
        }
    }

    public float getInnerAngle() {
        return this.innerAngle;
    }

    public void setInnerAngle(float innerAngle) {
        this.innerAngle = innerAngle;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.InnerAngle);
        }
    }

    public float getOuterAngle() {
        return this.outerAngle;
    }

    public void setOuterAngle(float outerAngle) {
        this.outerAngle = outerAngle;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.OuterAngle);
        }
    }

    public boolean isPositional() {
        return this.positional;
    }

    public void setPositional(boolean positional) {
        this.positional = positional;
        if (this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.IsPositional);
        }
    }

    public void updateGeometricState() {
        boolean updatePos = false;
        if ((this.refreshFlags & 1) != 0) {
            updatePos = true;
        }
        super.updateGeometricState();
        if (updatePos && this.channel >= 0) {
            this.getRenderer().updateSourceParam(this, AudioParam.Position);
        }
    }

    public AudioNode clone() {
        AudioNode clone = (AudioNode)super.clone();
        clone.direction = this.direction.clone();
        clone.velocity = this.velocity.clone();
        return clone;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.key, "key", null);
        oc.write(this.loop, "looping", false);
        oc.write(this.volume, "volume", 1.0f);
        oc.write(this.pitch, "pitch", 1.0f);
        oc.write(this.timeOffset, "time_offset", 0.0f);
        oc.write(this.dryFilter, "dry_filter", null);
        oc.write(this.velocity, "velocity", null);
        oc.write(this.reverbEnabled, "reverb_enabled", false);
        oc.write(this.reverbFilter, "reverb_filter", null);
        oc.write(this.maxDistance, "max_distance", 20.0f);
        oc.write(this.refDistance, "ref_distance", 10.0f);
        oc.write(this.directional, "directional", false);
        oc.write(this.direction, "direction", null);
        oc.write(this.innerAngle, "inner_angle", 360.0f);
        oc.write(this.outerAngle, "outer_angle", 360.0f);
        oc.write(this.positional, "positional", false);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.key = (AudioKey)ic.readSavable("key", null);
        this.loop = ic.readBoolean("looping", false);
        this.volume = ic.readFloat("volume", 1.0f);
        this.pitch = ic.readFloat("pitch", 1.0f);
        this.timeOffset = ic.readFloat("time_offset", 0.0f);
        this.dryFilter = (Filter)ic.readSavable("dry_filter", null);
        this.velocity = (Vector3f)ic.readSavable("velocity", null);
        this.reverbEnabled = ic.readBoolean("reverb_enabled", false);
        this.reverbFilter = (Filter)ic.readSavable("reverb_filter", null);
        this.maxDistance = ic.readFloat("max_distance", 20.0f);
        this.refDistance = ic.readFloat("ref_distance", 10.0f);
        this.directional = ic.readBoolean("directional", false);
        this.direction = (Vector3f)ic.readSavable("direction", null);
        this.innerAngle = ic.readFloat("inner_angle", 360.0f);
        this.outerAngle = ic.readFloat("outer_angle", 360.0f);
        this.positional = ic.readBoolean("positional", false);
        this.data = im.getAssetManager().loadAudio(this.key);
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + "[status=" + (Object)((Object)this.status);
        if (this.volume != 1.0f) {
            ret = ret + ", vol=" + this.volume;
        }
        if (this.pitch != 1.0f) {
            ret = ret + ", pitch=" + this.pitch;
        }
        return ret + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        Playing,
        Paused,
        Stopped;

    }
}

