/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.plugins.DXTFlipper;
import com.jme3.util.BufferUtils;
import com.jme3.util.LittleEndien;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDSLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(DDSLoader.class.getName());
    private static final boolean forceRGBA = false;
    private static final int DDSD_MANDATORY = 4103;
    private static final int DDSD_MANDATORY_DX10 = 6;
    private static final int DDSD_MIPMAPCOUNT = 131072;
    private static final int DDSD_LINEARSIZE = 524288;
    private static final int DDSD_DEPTH = 0x800000;
    private static final int DDPF_ALPHAPIXELS = 1;
    private static final int DDPF_FOURCC = 4;
    private static final int DDPF_RGB = 64;
    private static final int DDPF_GRAYSCALE = 131072;
    private static final int DDPF_ALPHA = 2;
    private static final int DDPF_NORMAL = Integer.MIN_VALUE;
    private static final int SWIZZLE_xGxR = 2017949778;
    private static final int DDSCAPS_COMPLEX = 8;
    private static final int DDSCAPS_TEXTURE = 4096;
    private static final int DDSCAPS_MIPMAP = 0x400000;
    private static final int DDSCAPS2_CUBEMAP = 512;
    private static final int DDSCAPS2_VOLUME = 0x200000;
    private static final int PF_DXT1 = 827611204;
    private static final int PF_DXT3 = 861165636;
    private static final int PF_DXT5 = 894720068;
    private static final int PF_ATI1 = 826889281;
    private static final int PF_ATI2 = 843666497;
    private static final int PF_DX10 = 808540228;
    private static final int DX10DIM_BUFFER = 1;
    private static final int DX10DIM_TEXTURE1D = 2;
    private static final int DX10DIM_TEXTURE2D = 3;
    private static final int DX10DIM_TEXTURE3D = 4;
    private static final int DX10MISC_GENERATE_MIPS = 1;
    private static final int DX10MISC_TEXTURECUBE = 4;
    private static final double LOG2 = Math.log(2.0);
    private int width;
    private int height;
    private int depth;
    private int flags;
    private int pitchOrSize;
    private int mipMapCount;
    private int caps1;
    private int caps2;
    private boolean directx10;
    private boolean compressed;
    private boolean texture3D;
    private boolean grayscaleOrAlpha;
    private boolean normal;
    private Image.Format pixelFormat;
    private int bpp;
    private int[] sizes;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;
    private DataInput in;

    @Override
    public Object load(AssetInfo info) throws IOException {
        if (!(info.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        InputStream stream = info.openStream();
        this.in = new LittleEndien(stream);
        this.loadHeader();
        if (this.texture3D) {
            ((TextureKey)info.getKey()).setTextureTypeHint(Texture.Type.ThreeDimensional);
        } else if (this.depth > 1) {
            ((TextureKey)info.getKey()).setTextureTypeHint(Texture.Type.CubeMap);
        }
        ArrayList<ByteBuffer> data = this.readData(((TextureKey)info.getKey()).isFlipY());
        stream.close();
        return new Image(this.pixelFormat, this.width, this.height, this.depth, data, this.sizes);
    }

    public Image load(InputStream stream) throws IOException {
        this.in = new LittleEndien(stream);
        this.loadHeader();
        ArrayList<ByteBuffer> data = this.readData(false);
        return new Image(this.pixelFormat, this.width, this.height, this.depth, data, this.sizes);
    }

    private void loadDX10Header() throws IOException {
        int dxgiFormat = this.in.readInt();
        if (dxgiFormat != 83) {
            throw new IOException("Only DXGI_FORMAT_BC5_UNORM is supported for DirectX10 DDS! Got: " + dxgiFormat);
        }
        this.pixelFormat = Image.Format.LATC;
        this.bpp = 8;
        this.compressed = true;
        int resDim = this.in.readInt();
        if (resDim == 4) {
            this.texture3D = true;
        }
        int miscFlag = this.in.readInt();
        int arraySize = this.in.readInt();
        if (DDSLoader.is(miscFlag, 4) && arraySize != 6) {
            throw new IOException("Cubemaps should consist of 6 images!");
        }
        this.in.skipBytes(4);
    }

    private void loadHeader() throws IOException {
        if (this.in.readInt() != 542327876 || this.in.readInt() != 124) {
            throw new IOException("Not a DDS file");
        }
        this.flags = this.in.readInt();
        if (!DDSLoader.is(this.flags, 4103) && !DDSLoader.is(this.flags, 6)) {
            throw new IOException("Mandatory flags missing");
        }
        this.height = this.in.readInt();
        this.width = this.in.readInt();
        this.pitchOrSize = this.in.readInt();
        this.depth = this.in.readInt();
        this.mipMapCount = this.in.readInt();
        this.in.skipBytes(44);
        this.pixelFormat = null;
        this.directx10 = false;
        this.readPixelFormat();
        this.caps1 = this.in.readInt();
        this.caps2 = this.in.readInt();
        this.in.skipBytes(12);
        this.texture3D = false;
        if (!this.directx10) {
            if (!DDSLoader.is(this.caps1, 4096)) {
                throw new IOException("File is not a texture");
            }
            if (this.depth <= 0) {
                this.depth = 1;
            }
            if (DDSLoader.is(this.caps2, 512)) {
                this.depth = 6;
            }
            if (DDSLoader.is(this.caps2, 0x200000)) {
                this.texture3D = true;
            }
        }
        int expectedMipmaps = 1 + (int)Math.ceil(Math.log(Math.max(this.height, this.width)) / LOG2);
        if (DDSLoader.is(this.caps1, 0x400000)) {
            if (!DDSLoader.is(this.flags, 131072)) {
                this.mipMapCount = expectedMipmaps;
            } else if (this.mipMapCount != expectedMipmaps) {
                logger.log(Level.WARNING, "Got {0} mipmaps, expected {1}", new Object[]{this.mipMapCount, expectedMipmaps});
            }
        } else {
            this.mipMapCount = 1;
        }
        if (this.directx10) {
            this.loadDX10Header();
        }
        this.loadSizes();
    }

    private void readPixelFormat() throws IOException {
        int pfSize = this.in.readInt();
        if (pfSize != 32) {
            throw new IOException("Pixel format size is " + pfSize + ", not 32");
        }
        int pfFlags = this.in.readInt();
        this.normal = DDSLoader.is(pfFlags, Integer.MIN_VALUE);
        if (DDSLoader.is(pfFlags, 4)) {
            this.compressed = true;
            int fourcc = this.in.readInt();
            int swizzle = this.in.readInt();
            this.in.skipBytes(16);
            switch (fourcc) {
                case 827611204: {
                    this.bpp = 4;
                    if (DDSLoader.is(pfFlags, 1)) {
                        this.pixelFormat = Image.Format.DXT1A;
                        break;
                    }
                    this.pixelFormat = Image.Format.DXT1;
                    break;
                }
                case 861165636: {
                    this.bpp = 8;
                    this.pixelFormat = Image.Format.DXT3;
                    break;
                }
                case 894720068: {
                    this.bpp = 8;
                    this.pixelFormat = Image.Format.DXT5;
                    if (swizzle != 2017949778) break;
                    this.normal = true;
                    break;
                }
                case 826889281: {
                    this.bpp = 4;
                    this.pixelFormat = Image.Format.LTC;
                    break;
                }
                case 843666497: {
                    this.bpp = 8;
                    this.pixelFormat = Image.Format.LATC;
                    break;
                }
                case 808540228: {
                    this.compressed = false;
                    this.directx10 = true;
                    return;
                }
                default: {
                    throw new IOException("Unknown fourcc: " + DDSLoader.string(fourcc) + ", " + Integer.toHexString(fourcc));
                }
            }
            int size = (this.width + 3) / 4 * ((this.height + 3) / 4) * this.bpp * 2;
            if (DDSLoader.is(this.flags, 524288)) {
                if (this.pitchOrSize == 0) {
                    logger.warning("Must use linear size with fourcc");
                    this.pitchOrSize = size;
                } else if (this.pitchOrSize != size) {
                    logger.log(Level.WARNING, "Expected size = {0}, real = {1}", new Object[]{size, this.pitchOrSize});
                }
            } else {
                this.pitchOrSize = size;
            }
        } else {
            this.compressed = false;
            this.in.readInt();
            this.bpp = this.in.readInt();
            this.redMask = this.in.readInt();
            this.greenMask = this.in.readInt();
            this.blueMask = this.in.readInt();
            this.alphaMask = this.in.readInt();
            if (DDSLoader.is(pfFlags, 64)) {
                this.pixelFormat = DDSLoader.is(pfFlags, 1) ? Image.Format.RGBA8 : Image.Format.RGB8;
            } else if (DDSLoader.is(pfFlags, 131072) && DDSLoader.is(pfFlags, 1)) {
                switch (this.bpp) {
                    case 16: {
                        this.pixelFormat = Image.Format.Luminance8Alpha8;
                        break;
                    }
                    case 32: {
                        this.pixelFormat = Image.Format.Luminance16Alpha16;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported GrayscaleAlpha BPP: " + this.bpp);
                    }
                }
                this.grayscaleOrAlpha = true;
            } else if (DDSLoader.is(pfFlags, 131072)) {
                switch (this.bpp) {
                    case 8: {
                        this.pixelFormat = Image.Format.Luminance8;
                        break;
                    }
                    case 16: {
                        this.pixelFormat = Image.Format.Luminance16;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported Grayscale BPP: " + this.bpp);
                    }
                }
                this.grayscaleOrAlpha = true;
            } else if (DDSLoader.is(pfFlags, 2)) {
                switch (this.bpp) {
                    case 8: {
                        this.pixelFormat = Image.Format.Alpha8;
                        break;
                    }
                    case 16: {
                        this.pixelFormat = Image.Format.Alpha16;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported Alpha BPP: " + this.bpp);
                    }
                }
                this.grayscaleOrAlpha = true;
            } else {
                throw new IOException("Unknown PixelFormat in DDS file");
            }
            int size = this.bpp / 8 * this.width;
            if (DDSLoader.is(this.flags, 524288)) {
                if (this.pitchOrSize == 0) {
                    logger.warning("Linear size said to contain valid value but does not");
                    this.pitchOrSize = size;
                } else if (this.pitchOrSize != size) {
                    logger.log(Level.WARNING, "Expected size = {0}, real = {1}", new Object[]{size, this.pitchOrSize});
                }
            } else {
                this.pitchOrSize = size;
            }
        }
    }

    private void loadSizes() {
        int mipWidth = this.width;
        int mipHeight = this.height;
        this.sizes = new int[this.mipMapCount];
        int outBpp = this.pixelFormat.getBitsPerPixel();
        for (int i = 0; i < this.mipMapCount; ++i) {
            int size = this.compressed ? (mipWidth + 3) / 4 * ((mipHeight + 3) / 4) * outBpp * 2 : mipWidth * mipHeight * outBpp / 8;
            this.sizes[i] = (size + 3) / 4 * 4;
            mipWidth = Math.max(mipWidth / 2, 1);
            mipHeight = Math.max(mipHeight / 2, 1);
        }
    }

    public byte[] flipData(byte[] data, int scanlineSize, int height) {
        byte[] newData = new byte[data.length];
        for (int y = 0; y < height; ++y) {
            System.arraycopy(data, y * scanlineSize, newData, (height - y - 1) * scanlineSize, scanlineSize);
        }
        return newData;
    }

    public ByteBuffer readGrayscale2D(boolean flip, int totalSize) throws IOException {
        ByteBuffer buffer = BufferUtils.createByteBuffer(totalSize);
        if (this.bpp == 8) {
            logger.finest("Source image format: R8");
        }
        assert (this.bpp == this.pixelFormat.getBitsPerPixel());
        int mipWidth = this.width;
        int mipHeight = this.height;
        for (int mip = 0; mip < this.mipMapCount; ++mip) {
            byte[] data = new byte[this.sizes[mip]];
            this.in.readFully(data);
            if (flip) {
                data = this.flipData(data, mipWidth * this.bpp / 8, mipHeight);
            }
            buffer.put(data);
            mipWidth = Math.max(mipWidth / 2, 1);
            mipHeight = Math.max(mipHeight / 2, 1);
        }
        return buffer;
    }

    public ByteBuffer readRGB2D(boolean flip, int totalSize) throws IOException {
        int redCount = DDSLoader.count(this.redMask);
        int blueCount = DDSLoader.count(this.blueMask);
        int greenCount = DDSLoader.count(this.greenMask);
        int alphaCount = DDSLoader.count(this.alphaMask);
        if (this.redMask == 0xFF0000 && this.greenMask == 65280 && this.blueMask == 255) {
            if (this.alphaMask == -16777216 && this.bpp == 32) {
                logger.finest("Data source format: BGRA8");
            } else if (this.bpp == 24) {
                logger.finest("Data source format: BGR8");
            }
        }
        int sourcebytesPP = this.bpp / 8;
        int targetBytesPP = this.pixelFormat.getBitsPerPixel() / 8;
        ByteBuffer dataBuffer = BufferUtils.createByteBuffer(totalSize);
        int mipWidth = this.width;
        int mipHeight = this.height;
        int offset = 0;
        byte[] b = new byte[sourcebytesPP];
        for (int mip = 0; mip < this.mipMapCount; ++mip) {
            for (int y = 0; y < mipHeight; ++y) {
                for (int x = 0; x < mipWidth; ++x) {
                    this.in.readFully(b);
                    int i = DDSLoader.byte2int(b);
                    byte red = (byte)((i & this.redMask) >> redCount);
                    byte green = (byte)((i & this.greenMask) >> greenCount);
                    byte blue = (byte)((i & this.blueMask) >> blueCount);
                    byte alpha = (byte)((i & this.alphaMask) >> alphaCount);
                    if (flip) {
                        dataBuffer.position(offset + ((mipHeight - y - 1) * mipWidth + x) * targetBytesPP);
                    }
                    if (this.alphaMask == 0) {
                        dataBuffer.put(red).put(green).put(blue);
                        continue;
                    }
                    dataBuffer.put(red).put(green).put(blue).put(alpha);
                }
            }
            offset += mipWidth * mipHeight * targetBytesPP;
            mipWidth = Math.max(mipWidth / 2, 1);
            mipHeight = Math.max(mipHeight / 2, 1);
        }
        return dataBuffer;
    }

    public ByteBuffer readDXT2D(boolean flip, int totalSize) throws IOException {
        logger.finest("Source image format: DXT");
        ByteBuffer buffer = BufferUtils.createByteBuffer(totalSize);
        int mipWidth = this.width;
        int mipHeight = this.height;
        for (int mip = 0; mip < this.mipMapCount; ++mip) {
            byte[] data;
            if (flip) {
                data = new byte[this.sizes[mip]];
                this.in.readFully(data);
                ByteBuffer wrapped = ByteBuffer.wrap(data);
                wrapped.rewind();
                ByteBuffer flipped = DXTFlipper.flipDXT(wrapped, mipWidth, mipHeight, this.pixelFormat);
                buffer.put(flipped);
            } else {
                data = new byte[this.sizes[mip]];
                this.in.readFully(data);
                buffer.put(data);
            }
            mipWidth = Math.max(mipWidth / 2, 1);
            mipHeight = Math.max(mipHeight / 2, 1);
        }
        buffer.rewind();
        return buffer;
    }

    public ByteBuffer readGrayscale3D(boolean flip, int totalSize) throws IOException {
        ByteBuffer buffer = BufferUtils.createByteBuffer(totalSize * this.depth);
        if (this.bpp == 8) {
            logger.finest("Source image format: R8");
        }
        assert (this.bpp == this.pixelFormat.getBitsPerPixel());
        for (int i = 0; i < this.depth; ++i) {
            int mipWidth = this.width;
            int mipHeight = this.height;
            for (int mip = 0; mip < this.mipMapCount; ++mip) {
                byte[] data = new byte[this.sizes[mip]];
                this.in.readFully(data);
                if (flip) {
                    data = this.flipData(data, mipWidth * this.bpp / 8, mipHeight);
                }
                buffer.put(data);
                mipWidth = Math.max(mipWidth / 2, 1);
                mipHeight = Math.max(mipHeight / 2, 1);
            }
        }
        buffer.rewind();
        return buffer;
    }

    public ByteBuffer readRGB3D(boolean flip, int totalSize) throws IOException {
        int redCount = DDSLoader.count(this.redMask);
        int blueCount = DDSLoader.count(this.blueMask);
        int greenCount = DDSLoader.count(this.greenMask);
        int alphaCount = DDSLoader.count(this.alphaMask);
        if (this.redMask == 0xFF0000 && this.greenMask == 65280 && this.blueMask == 255) {
            if (this.alphaMask == -16777216 && this.bpp == 32) {
                logger.finest("Data source format: BGRA8");
            } else if (this.bpp == 24) {
                logger.finest("Data source format: BGR8");
            }
        }
        int sourcebytesPP = this.bpp / 8;
        int targetBytesPP = this.pixelFormat.getBitsPerPixel() / 8;
        ByteBuffer dataBuffer = BufferUtils.createByteBuffer(totalSize * this.depth);
        for (int k = 0; k < this.depth; ++k) {
            int mipWidth = this.width;
            int mipHeight = this.height;
            int offset = k * totalSize;
            byte[] b = new byte[sourcebytesPP];
            for (int mip = 0; mip < this.mipMapCount; ++mip) {
                for (int y = 0; y < mipHeight; ++y) {
                    for (int x = 0; x < mipWidth; ++x) {
                        this.in.readFully(b);
                        int i = DDSLoader.byte2int(b);
                        byte red = (byte)((i & this.redMask) >> redCount);
                        byte green = (byte)((i & this.greenMask) >> greenCount);
                        byte blue = (byte)((i & this.blueMask) >> blueCount);
                        byte alpha = (byte)((i & this.alphaMask) >> alphaCount);
                        if (flip) {
                            dataBuffer.position(offset + ((mipHeight - y - 1) * mipWidth + x) * targetBytesPP);
                        }
                        if (this.alphaMask == 0) {
                            dataBuffer.put(red).put(green).put(blue);
                            continue;
                        }
                        dataBuffer.put(red).put(green).put(blue).put(alpha);
                    }
                }
                offset += mipWidth * mipHeight * targetBytesPP;
                mipWidth = Math.max(mipWidth / 2, 1);
                mipHeight = Math.max(mipHeight / 2, 1);
            }
        }
        dataBuffer.rewind();
        return dataBuffer;
    }

    public ByteBuffer readDXT3D(boolean flip, int totalSize) throws IOException {
        logger.finest("Source image format: DXT");
        ByteBuffer bufferAll = BufferUtils.createByteBuffer(totalSize * this.depth);
        for (int i = 0; i < this.depth; ++i) {
            ByteBuffer buffer = BufferUtils.createByteBuffer(totalSize);
            int mipWidth = this.width;
            int mipHeight = this.height;
            for (int mip = 0; mip < this.mipMapCount; ++mip) {
                byte[] data;
                if (flip) {
                    data = new byte[this.sizes[mip]];
                    this.in.readFully(data);
                    ByteBuffer wrapped = ByteBuffer.wrap(data);
                    wrapped.rewind();
                    ByteBuffer flipped = DXTFlipper.flipDXT(wrapped, mipWidth, mipHeight, this.pixelFormat);
                    flipped.rewind();
                    buffer.put(flipped);
                } else {
                    data = new byte[this.sizes[mip]];
                    this.in.readFully(data);
                    buffer.put(data);
                }
                mipWidth = Math.max(mipWidth / 2, 1);
                mipHeight = Math.max(mipHeight / 2, 1);
            }
            buffer.rewind();
            bufferAll.put(buffer);
        }
        return bufferAll;
    }

    public ArrayList<ByteBuffer> readData(boolean flip) throws IOException {
        int totalSize = 0;
        for (int i = 0; i < this.sizes.length; ++i) {
            totalSize += this.sizes[i];
        }
        ArrayList<ByteBuffer> allMaps = new ArrayList<ByteBuffer>();
        if (this.depth > 1 && !this.texture3D) {
            for (int i = 0; i < this.depth; ++i) {
                if (this.compressed) {
                    allMaps.add(this.readDXT2D(flip, totalSize));
                    continue;
                }
                if (this.grayscaleOrAlpha) {
                    allMaps.add(this.readGrayscale2D(flip, totalSize));
                    continue;
                }
                allMaps.add(this.readRGB2D(flip, totalSize));
            }
        } else if (this.texture3D) {
            if (this.compressed) {
                allMaps.add(this.readDXT3D(flip, totalSize));
            } else if (this.grayscaleOrAlpha) {
                allMaps.add(this.readGrayscale3D(flip, totalSize));
            } else {
                allMaps.add(this.readRGB3D(flip, totalSize));
            }
        } else if (this.compressed) {
            allMaps.add(this.readDXT2D(flip, totalSize));
        } else if (this.grayscaleOrAlpha) {
            allMaps.add(this.readGrayscale2D(flip, totalSize));
        } else {
            allMaps.add(this.readRGB2D(flip, totalSize));
        }
        return allMaps;
    }

    private static boolean is(int flags, int mask) {
        return (flags & mask) == mask;
    }

    private static int count(int n) {
        if (n == 0) {
            return 0;
        }
        int i = 0;
        while ((n & 1) == 0) {
            n >>= 1;
            if (++i <= 32) continue;
            throw new RuntimeException(Integer.toHexString(n));
        }
        return i;
    }

    private static int byte2int(byte[] b) {
        if (b.length == 1) {
            return b[0] & 0xFF;
        }
        if (b.length == 2) {
            return b[0] & 0xFF | (b[1] & 0xFF) << 8;
        }
        if (b.length == 3) {
            return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16;
        }
        if (b.length == 4) {
            return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
        }
        return 0;
    }

    private static String string(int value) {
        StringBuilder buf = new StringBuilder();
        buf.append((char)(value & 0xFF));
        buf.append((char)((value & 0xFF00) >> 8));
        buf.append((char)((value & 0xFF0000) >> 16));
        buf.append((char)((value & 0xFF00000) >> 24));
        return buf.toString();
    }
}

