/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.control;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class BillboardControl
extends AbstractControl {
    private Matrix3f orient = new Matrix3f();
    private Vector3f look = new Vector3f();
    private Vector3f left = new Vector3f();
    private Alignment alignment = Alignment.Screen;

    public Control cloneForSpatial(Spatial spatial) {
        BillboardControl control = new BillboardControl();
        control.alignment = this.alignment;
        control.setSpatial(spatial);
        return control;
    }

    protected void controlUpdate(float tpf) {
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
        Camera cam = vp.getCamera();
        this.rotateBillboard(cam);
    }

    private void fixRefreshFlags() {
        this.spatial.updateGeometricState();
        Spatial rootNode = this.spatial;
        while (rootNode.getParent() != null) {
            rootNode = rootNode.getParent();
        }
        rootNode.getWorldBound();
    }

    private void rotateBillboard(Camera cam) {
        switch (this.alignment) {
            case AxialY: {
                this.rotateAxial(cam, Vector3f.UNIT_Y);
                break;
            }
            case AxialZ: {
                this.rotateAxial(cam, Vector3f.UNIT_Z);
                break;
            }
            case Screen: {
                this.rotateScreenAligned(cam);
                break;
            }
            case Camera: {
                this.rotateCameraAligned(cam);
            }
        }
    }

    private void rotateCameraAligned(Camera camera) {
        this.look.set(camera.getLocation()).subtractLocal(this.spatial.getWorldTranslation());
        Vector3f xzp = this.left;
        xzp.set(this.look.x, 0.0f, this.look.z);
        if (xzp.equals(Vector3f.ZERO)) {
            return;
        }
        this.look.normalizeLocal();
        xzp.normalizeLocal();
        float cosp = this.look.dot(xzp);
        this.orient.set(0, 0, xzp.z);
        this.orient.set(0, 1, xzp.x * -this.look.y);
        this.orient.set(0, 2, xzp.x * cosp);
        this.orient.set(1, 0, 0.0f);
        this.orient.set(1, 1, cosp);
        this.orient.set(1, 2, this.look.y);
        this.orient.set(2, 0, -xzp.x);
        this.orient.set(2, 1, xzp.z * -this.look.y);
        this.orient.set(2, 2, xzp.z * cosp);
        this.spatial.setLocalRotation(this.orient);
        this.fixRefreshFlags();
    }

    private void rotateScreenAligned(Camera camera) {
        this.look.set(camera.getDirection()).negateLocal();
        this.left.set(camera.getLeft()).negateLocal();
        this.orient.fromAxes(this.left, camera.getUp(), this.look);
        Node parent = this.spatial.getParent();
        Quaternion rot = new Quaternion().fromRotationMatrix(this.orient);
        if (parent != null) {
            rot = parent.getWorldRotation().inverse().multLocal(rot);
            rot.normalizeLocal();
        }
        this.spatial.setLocalRotation(rot);
        this.fixRefreshFlags();
    }

    private void rotateAxial(Camera camera, Vector3f axis) {
        this.look.set(camera.getLocation()).subtractLocal(this.spatial.getWorldTranslation());
        this.spatial.getParent().getWorldRotation().mult(this.look, this.left);
        this.left.x *= 1.0f / this.spatial.getWorldScale().x;
        this.left.y *= 1.0f / this.spatial.getWorldScale().y;
        this.left.z *= 1.0f / this.spatial.getWorldScale().z;
        float lengthSquared = this.left.x * this.left.x + this.left.z * this.left.z;
        if (lengthSquared < 1.1920929E-7f) {
            return;
        }
        float invLength = FastMath.invSqrt(lengthSquared);
        if (axis.y == 1.0f) {
            this.left.x *= invLength;
            this.left.y = 0.0f;
            this.left.z *= invLength;
            this.orient.set(0, 0, this.left.z);
            this.orient.set(0, 1, 0.0f);
            this.orient.set(0, 2, this.left.x);
            this.orient.set(1, 0, 0.0f);
            this.orient.set(1, 1, 1.0f);
            this.orient.set(1, 2, 0.0f);
            this.orient.set(2, 0, -this.left.x);
            this.orient.set(2, 1, 0.0f);
            this.orient.set(2, 2, this.left.z);
        } else if (axis.z == 1.0f) {
            this.left.x *= invLength;
            this.left.y *= invLength;
            this.left.z = 0.0f;
            this.orient.set(0, 0, this.left.y);
            this.orient.set(0, 1, this.left.x);
            this.orient.set(0, 2, 0.0f);
            this.orient.set(1, 0, -this.left.y);
            this.orient.set(1, 1, this.left.x);
            this.orient.set(1, 2, 0.0f);
            this.orient.set(2, 0, 0.0f);
            this.orient.set(2, 1, 0.0f);
            this.orient.set(2, 2, 1.0f);
        }
        this.spatial.setLocalRotation(this.orient);
        this.fixRefreshFlags();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.orient, "orient", null);
        capsule.write(this.look, "look", null);
        capsule.write(this.left, "left", null);
        capsule.write(this.alignment, "alignment", Alignment.Screen);
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.orient = (Matrix3f)capsule.readSavable("orient", null);
        this.look = (Vector3f)capsule.readSavable("look", null);
        this.left = (Vector3f)capsule.readSavable("left", null);
        this.alignment = capsule.readEnum("alignment", Alignment.class, Alignment.Screen);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        Screen,
        Camera,
        AxialY,
        AxialZ;

    }
}

