/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.rmi;

import com.jme3.network.rmi.MethodDef;
import com.jme3.network.rmi.ObjectDef;
import com.jme3.network.rmi.RemoteMethodCallMessage;
import com.jme3.network.rmi.RemoteMethodReturnMessage;
import com.jme3.network.rmi.RemoteObjectDefMessage;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.SerializerRegistration;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiSerializer
extends Serializer {
    private static final Logger logger = Logger.getLogger(RmiSerializer.class.getName());
    private char[] chrBuf = new char[256];

    private void writeString(ByteBuffer buffer, String string2) throws IOException {
        int length = string2.length();
        if (length > 255) {
            logger.log(Level.WARNING, "The string length exceeds the limit! {0} > 255", length);
            buffer.put((byte)0);
            return;
        }
        buffer.put((byte)length);
        for (int i = 0; i < length; ++i) {
            buffer.put((byte)string2.charAt(i));
        }
    }

    private String readString(ByteBuffer buffer) {
        int length = buffer.get() & 0xFF;
        for (int i = 0; i < length; ++i) {
            this.chrBuf[i] = (char)(buffer.get() & 0xFF);
        }
        return String.valueOf(this.chrBuf, 0, length);
    }

    private void writeType(ByteBuffer buffer, Class<?> clazz) throws IOException {
        if (clazz == Void.TYPE) {
            buffer.putShort((short)0);
        } else {
            SerializerRegistration reg = Serializer.getSerializerRegistration(clazz);
            if (reg == null) {
                logger.log(Level.WARNING, "Unknown class: {0}", clazz);
                throw new IOException();
            }
            buffer.putShort(reg.getId());
        }
    }

    private Class<?> readType(ByteBuffer buffer) throws IOException {
        SerializerRegistration reg = Serializer.readClass(buffer);
        if (reg == null) {
            short id = buffer.getShort(buffer.position() - 2);
            if (id == 0) {
                return Void.TYPE;
            }
            logger.log(Level.WARNING, "Undefined class ID: {0}", id);
            throw new IOException();
        }
        return reg.getType();
    }

    private void writeMethod(ByteBuffer buffer, Method method) throws IOException {
        String name = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        this.writeString(buffer, name);
        this.writeType(buffer, returnType);
        buffer.put((byte)paramTypes.length);
        for (Class<?> paramType : paramTypes) {
            this.writeType(buffer, paramType);
        }
    }

    private MethodDef readMethod(ByteBuffer buffer) throws IOException {
        String name = this.readString(buffer);
        Class<?> retType = this.readType(buffer);
        int numParams = buffer.get() & 0xFF;
        Class[] paramTypes = new Class[numParams];
        for (int i = 0; i < numParams; ++i) {
            paramTypes[i] = this.readType(buffer);
        }
        MethodDef def = new MethodDef();
        def.name = name;
        def.paramTypes = paramTypes;
        def.retType = retType;
        return def;
    }

    private void writeObjectDef(ByteBuffer buffer, ObjectDef def) throws IOException {
        buffer.putShort((short)def.objectId);
        this.writeString(buffer, def.objectName);
        Method[] methods = def.methods;
        buffer.put((byte)methods.length);
        for (Method method : methods) {
            this.writeMethod(buffer, method);
        }
    }

    private ObjectDef readObjectDef(ByteBuffer buffer) throws IOException {
        ObjectDef def = new ObjectDef();
        def.objectId = buffer.getShort();
        def.objectName = this.readString(buffer);
        int numMethods = buffer.get() & 0xFF;
        MethodDef[] methodDefs = new MethodDef[numMethods];
        for (int i = 0; i < numMethods; ++i) {
            methodDefs[i] = this.readMethod(buffer);
        }
        def.methodDefs = methodDefs;
        return def;
    }

    private void writeObjectDefs(ByteBuffer buffer, RemoteObjectDefMessage defMsg) throws IOException {
        ObjectDef[] defs = defMsg.objects;
        buffer.put((byte)defs.length);
        for (ObjectDef def : defs) {
            this.writeObjectDef(buffer, def);
        }
    }

    private RemoteObjectDefMessage readObjectDefs(ByteBuffer buffer) throws IOException {
        RemoteObjectDefMessage defMsg = new RemoteObjectDefMessage();
        int numObjs = buffer.get() & 0xFF;
        ObjectDef[] defs = new ObjectDef[numObjs];
        for (int i = 0; i < numObjs; ++i) {
            defs[i] = this.readObjectDef(buffer);
        }
        defMsg.objects = defs;
        return defMsg;
    }

    private void writeMethodCall(ByteBuffer buffer, RemoteMethodCallMessage call) throws IOException {
        buffer.putShort((short)call.objectId);
        buffer.putShort(call.methodId);
        buffer.putShort(call.invocationId);
        if (call.args == null) {
            buffer.put((byte)0);
        } else {
            buffer.put((byte)call.args.length);
            for (Object obj : call.args) {
                if (obj != null) {
                    buffer.put((byte)1);
                    Serializer.writeClassAndObject(buffer, obj);
                    continue;
                }
                buffer.put((byte)0);
            }
        }
    }

    private RemoteMethodCallMessage readMethodCall(ByteBuffer buffer) throws IOException {
        RemoteMethodCallMessage call = new RemoteMethodCallMessage();
        call.objectId = buffer.getShort();
        call.methodId = buffer.getShort();
        call.invocationId = buffer.getShort();
        int numArgs = buffer.get() & 0xFF;
        if (numArgs > 0) {
            Object[] args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                if (buffer.get() != 1) continue;
                args[i] = Serializer.readClassAndObject(buffer);
            }
            call.args = args;
        }
        return call;
    }

    private void writeMethodReturn(ByteBuffer buffer, RemoteMethodReturnMessage ret) throws IOException {
        buffer.putShort(ret.invocationID);
        if (ret.retVal != null) {
            buffer.put((byte)1);
            Serializer.writeClassAndObject(buffer, ret.retVal);
        } else {
            buffer.put((byte)0);
        }
    }

    private RemoteMethodReturnMessage readMethodReturn(ByteBuffer buffer) throws IOException {
        RemoteMethodReturnMessage ret = new RemoteMethodReturnMessage();
        ret.invocationID = buffer.getShort();
        if (buffer.get() == 1) {
            ret.retVal = Serializer.readClassAndObject(buffer);
        }
        return ret;
    }

    @Override
    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        if (c == RemoteObjectDefMessage.class) {
            return (T)this.readObjectDefs(data);
        }
        if (c == RemoteMethodCallMessage.class) {
            return (T)this.readMethodCall(data);
        }
        if (c == RemoteMethodReturnMessage.class) {
            return (T)this.readMethodReturn(data);
        }
        return null;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object instanceof RemoteObjectDefMessage) {
            RemoteObjectDefMessage def = (RemoteObjectDefMessage)object;
            this.writeObjectDefs(buffer, def);
        } else if (object instanceof RemoteMethodCallMessage) {
            RemoteMethodCallMessage call = (RemoteMethodCallMessage)object;
            this.writeMethodCall(buffer, call);
        } else if (object instanceof RemoteMethodReturnMessage) {
            RemoteMethodReturnMessage ret = (RemoteMethodReturnMessage)object;
            this.writeMethodReturn(buffer, ret);
        }
    }
}

