/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.LoopMode;
import com.jme3.math.FastMath;
import java.util.BitSet;

public final class AnimChannel {
    private static final float DEFAULT_BLEND_TIME = 0.15f;
    private AnimControl control;
    private BitSet affectedBones;
    private Animation animation;
    private Animation blendFrom;
    private float time;
    private float speed;
    private float timeBlendFrom;
    private float speedBlendFrom;
    private LoopMode loopMode;
    private LoopMode loopModeBlendFrom;
    private float blendAmount = 1.0f;
    private float blendRate = 0.0f;

    private static float clampWrapTime(float t, float max, LoopMode loopMode) {
        if (max == Float.POSITIVE_INFINITY) {
            return t;
        }
        if (t < 0.0f) {
            switch (loopMode) {
                case DontLoop: {
                    return 0.0f;
                }
                case Cycle: {
                    return t;
                }
                case Loop: {
                    return max - t;
                }
            }
        } else if (t > max) {
            switch (loopMode) {
                case DontLoop: {
                    return max;
                }
                case Cycle: {
                    return -(2.0f * max - t);
                }
                case Loop: {
                    return t - max;
                }
            }
        }
        return t;
    }

    AnimChannel(AnimControl control) {
        this.control = control;
    }

    public AnimControl getControl() {
        return this.control;
    }

    public String getAnimationName() {
        return this.animation != null ? this.animation.getName() : null;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = FastMath.clamp(time, 0.0f, this.getAnimMaxTime());
    }

    public float getAnimMaxTime() {
        return this.animation != null ? this.animation.getLength() : 0.0f;
    }

    public void setAnim(String name, float blendTime) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (blendTime < 0.0f) {
            throw new IllegalArgumentException("blendTime cannot be less than zero");
        }
        Animation anim = this.control.animationMap.get(name);
        if (anim == null) {
            throw new IllegalArgumentException("Cannot find animation named: '" + name + "'");
        }
        this.control.notifyAnimChange(this, name);
        if (this.animation != null && blendTime > 0.0f) {
            this.blendFrom = this.animation;
            this.timeBlendFrom = this.time;
            this.speedBlendFrom = this.speed;
            this.loopModeBlendFrom = this.loopMode;
            this.blendAmount = 0.0f;
            this.blendRate = 1.0f / blendTime;
        }
        this.animation = anim;
        this.time = 0.0f;
        this.speed = 1.0f;
        this.loopMode = LoopMode.Loop;
    }

    public void setAnim(String name) {
        this.setAnim(name, 0.15f);
    }

    public void addAllBones() {
        this.affectedBones = null;
    }

    public void addBone(String name) {
        this.addBone(this.control.getSkeleton().getBone(name));
    }

    public void addBone(Bone bone) {
        int boneIndex = this.control.getSkeleton().getBoneIndex(bone);
        if (this.affectedBones == null) {
            this.affectedBones = new BitSet(this.control.getSkeleton().getBoneCount());
        }
        this.affectedBones.set(boneIndex);
    }

    public void addToRootBone(String name) {
        this.addToRootBone(this.control.getSkeleton().getBone(name));
    }

    public void addToRootBone(Bone bone) {
        this.addBone(bone);
        while (bone.getParent() != null) {
            bone = bone.getParent();
            this.addBone(bone);
        }
    }

    public void addFromRootBone(String name) {
        this.addFromRootBone(this.control.getSkeleton().getBone(name));
    }

    public void addFromRootBone(Bone bone) {
        this.addBone(bone);
        if (bone.getChildren() == null) {
            return;
        }
        for (Bone childBone : bone.getChildren()) {
            this.addBone(childBone);
            this.addFromRootBone(childBone);
        }
    }

    BitSet getAffectedBones() {
        return this.affectedBones;
    }

    void update(float tpf) {
        if (this.animation == null) {
            return;
        }
        if (this.blendFrom != null) {
            this.blendFrom.setTime(this.timeBlendFrom, 1.0f - this.blendAmount, this.control, this);
            this.timeBlendFrom += tpf * this.speedBlendFrom;
            this.timeBlendFrom = AnimChannel.clampWrapTime(this.timeBlendFrom, this.blendFrom.getLength(), this.loopModeBlendFrom);
            if (this.timeBlendFrom < 0.0f) {
                this.timeBlendFrom = -this.timeBlendFrom;
                this.speedBlendFrom = -this.speedBlendFrom;
            }
            this.blendAmount += tpf * this.blendRate;
            if (this.blendAmount > 1.0f) {
                this.blendAmount = 1.0f;
                this.blendFrom = null;
            }
        }
        this.animation.setTime(this.time, this.blendAmount, this.control, this);
        this.time += tpf * this.speed;
        if (this.animation.getLength() > 0.0f) {
            if (this.time >= this.animation.getLength()) {
                this.control.notifyAnimCycleDone(this, this.animation.getName());
            } else if (this.time < 0.0f) {
                this.control.notifyAnimCycleDone(this, this.animation.getName());
            }
        }
        this.time = AnimChannel.clampWrapTime(this.time, this.animation.getLength(), this.loopMode);
        if (this.time < 0.0f) {
            this.time = -this.time;
            this.speed = -this.speed;
        }
    }
}

