#!/bin/sh
#
# startx11.sh - start X11
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
# On Leopard, DISPLAY is always set and X11 is launched automatically
# by launchd when an X client intends to connect to X server.
#
# The following code is for Tiger or prior. It launches X11 and guess
# its DISPLAY.
#

PATH=/usr/bin:/bin:/usr/sbin

if [ -z "$DISPLAY" ]; then
  osascript -e 'tell application "X11" to launch' || exit $?
  tmp=`mktemp -d -t tmp` || exit $?
  cat <<END > $tmp/getdisp
#!/bin/sh
if [ -n "\$DISPLAY" ]; then echo "$DISPLAY"; else echo ":0"; fi > '$tmp/disp'
END
  chmod +x $tmp/getdisp
  open-x11 $tmp/getdisp || \
  open -a X11 $tmp/getdisp || \
  open -a XDarwin $tmp/getdisp
  while [ "$?" == "0" ] && [ ! -f $tmp/disp ]; do sleep 1; done
  DISPLAY=`cat $tmp/disp`
  [ -n "$DISPLAY" ] || DISPLAY=:0
  rm -rf $tmp
fi

export DISPLAY
