#!/bin/sh
#
# infoplist.awk - substitute Info.plist
#
# awk -v ENTRYFILE=<_EntryXXX> \
#     -v MIKUVERSION=<version> \
#     -v BUNDLESUBID=<bundleIdentifier> \
#     -f infoplist.awk Info.plist
#
# Copyright (C) 2008 MikuInstaller Project. All rights reserved.
# http://mikuinstaller.sourceforge.jp/
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

BEGIN {
	SUBSEP = ":"
	while ((getline < ENTRYFILE) > 0) {
		ent[$1] = substr($0, length($1) + 2);
	}
}

function h(str) {
	sub("&", "\\&amp;", str);
	sub("\"", "\\&quot;", str);
	sub("<", "\\&lt;", str);
	sub(">", "\\&gt;", str);
	return str;
}

function insertBundleName()
{
	if (!("NAME" in ent)) return;
	sub("<.*$", "", $0);
	print $0 "<key>CFBundleName</key>"
	print $0 "<string>"h(ent["NAME"])"</string>";
	insertedBundleName = 1;
}

/<key>CFBundleName<\/key>/ {
	getline;
	insertBundleName();
	next;
}

function insertBundleIconFile()
{
	if (!("ICON" in ent)) return;
	sub("<.*$", "", $0);
	s = ent["ICON"];
	sub("\.tiff$", ".icns", s);
	print $0 "<key>CFBundleIconFile</key>";
	print $0 "<string>"h(s)"</string>";
	insertedBundleIconFile = 1;
}

/<key>CFBundleIconFile<\/key>/ {
	getline;
	insertBundleIconFile();
	next;
}

/<key>CFBundleGetInfoString<\/key>/ && MIKUVERSION {
	print;
	getline;
	content = $0;
	gsub("[ \t]*</?string>[ \t]*", "", content);
	sub("<.*$", "", $0);
	print $0 "<string>"content;
	print "Generated by MikuInstaller "MIKUVERSION"</string>";
	next;
}

/<key>CFBundleIdentifier<\/key>/ && BUNDLESUBID {
	print;
	getline;
	content = $0;
	gsub("[ \t]*</?string>[ \t]*", "", content);
	sub("<.*$", "", $0);
	print $0 "<string>"content"."BUNDLESUBID"</string>";
	next;
}

function insertBundleDocumentTypes()
{
	sub("<.*$", "", $0);
	print $0 "<key>CFBundleDocumentTypes<\/key>";
	print $0 "<array>";
	i = 0;
	while (("TYPE",i) in ent) {
		print $0 "\t<dict>";
		print $0 "\t\t<key>CFBundleTypeExtensions</key>";
		print $0 "\t\t<array>";
		j = 0;
		while (("TYPE",i,"SUFFIX",j) in ent) {
			print $0 "\t\t\t<string>" h(ent["TYPE",i,"SUFFIX",j]) "</string>";
			j += 1;
		}
		print $0 "\t\t</array>";
		if (ent["TYPE",i]) {
			print $0 "\t\t<key>CFBundleTypeName</key>";
			print $0 "\t\t<string>" h(ent["TYPE",i]) "</string>";
		}
		if (("TYPE",i,"ICON") in ent) {
			print $0 "\t\t<key>CFBundleTypeIconFile</key>";
			s = ent["TYPE",i,"ICON"];
			sub("\.tiff$", ".icns", s);
			print $0 "\t\t<string>" h(s) "</string>";
		}
		print $0 "\t\t<key>CFBundleTypeRole</key>";
		print $0 "\t\t<string>Viewer</string>";
		print $0 "\t</dict>";
		i += 1;
	}
	print $0 "</array>";
	insertedBundleDocumentTypes = 1;
}

/<key>CFBundleDocumentTypes<\/key>/ {
	getline;
	sub("<.*$", "", $0);
	while (getline t > 0 && match("^"$0"</array>$", t) == 0);
	insertBundleDocumentTypes();
	next;
}

/^<\/dict>/ {
	orig = $0;
	$0 = $0"\t";
	if (insertedBundleName == 0)
		insertBundleName();
	if (insertedBundleIconFile == 0)
		insertBundleIconFile();
	if (insertedBundleDocumentTypes == 0)
		insertBundleDocumentTypes();
	print orig;
	next;
}

{
	print;
}
