/*
 * Decompiled with CFR 0.152.
 */
package mikanframework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import mikanframework.util.ExceptionHelper;

public class IOHelper {
    public static InputStream getResouceInputStream(String string) throws FileNotFoundException, IOException, URISyntaxException {
        InputStream inputStream = null;
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        int n = uRL.toString().indexOf("jar!");
        if (n > 0) {
            String string2 = uRL.toString().substring(9, n + 3);
            String string3 = uRL.toString().substring(n + 5);
            JarFile jarFile = new JarFile(string2);
            JarEntry jarEntry = jarFile.getJarEntry(string3);
            inputStream = jarFile.getInputStream(jarEntry);
        } else {
            inputStream = new FileInputStream(uRL.toURI().getRawPath());
        }
        if (inputStream == null) {
            throw new IOException();
        }
        return inputStream;
    }

    public static List<String> getFilePathList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string.startsWith("jar:file:")) {
                int n = string.indexOf("jar!");
                String string2 = string.substring("jar:file:".length(), n + 3);
                JarFile jarFile = new JarFile(string2);
                IOHelper.addFilePathList(arrayList, jarFile);
            } else if (string.startsWith("file:")) {
                String string3 = string.substring("file:".length(), string.length());
                File file = new File(string3);
                IOHelper.addFilePathList(arrayList, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static void addFilePathList(List<String> list, File file) {
        if (file.isFile() && file.canRead()) {
            list.add(file.toURI().getRawPath());
            return;
        }
        if (file.isDirectory() && file.canRead()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                IOHelper.addFilePathList(list, fileArray[i]);
            }
        }
    }

    public static void addFilePathList(List<String> list, JarFile jarFile) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            list.add(jarEntry.getName());
        }
    }

    public static boolean getBooleanOrFalse(Map<String, Object> map, String string) {
        try {
            String string2 = (String)IOHelper.getValueOrNull(map, string, "");
            if (string2 == null) {
                return false;
            }
            return Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getStringOrDie(Map<String, Object> map, String string, String string2) {
        String string3 = (String)IOHelper.getValueOrDie(map, string, string2);
        return string3;
    }

    public static List<Map<String, Object>> getMapListOrNew(Map<String, Object> map, String string) {
        ArrayList arrayList = (ArrayList)IOHelper.getValueOrNull(map, string, "");
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public static <T> T getValueOrDie(Map<String, Object> map, String string, String string2) {
        Object object = null;
        Object object2 = map.get(string);
        if (object2 == null) {
            throw ExceptionHelper.wrapException(string2);
        }
        try {
            object = object2;
        }
        catch (Exception exception) {
            throw ExceptionHelper.wrapException(string2, exception);
        }
        return (T)object;
    }

    public static <T> T getValueOrNull(Map<String, Object> map, String string, String string2) {
        Object object = null;
        Object object2 = map.get(string);
        if (object2 == null) {
            return null;
        }
        try {
            object = object2;
        }
        catch (Exception exception) {
            throw ExceptionHelper.wrapException(string2, exception);
        }
        return (T)object;
    }

    public static <T> Class<T> getClassOrDie(String string, String string2) {
        Class<?> clazz = null;
        try {
            Class<?> clazz2;
            clazz = clazz2 = Class.forName(string);
        }
        catch (Exception exception) {
            throw ExceptionHelper.wrapException(string2, exception);
        }
        return clazz;
    }

    public static <T> T castOrDie(Object object, String string) {
        try {
            return (T)object;
        }
        catch (ClassCastException classCastException) {
            throw ExceptionHelper.wrapException(string, classCastException);
        }
    }
}

