/*
 * Decompiled with CFR 0.152.
 */
package mikanframework.core;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mikanframework.core.ProxySkin;
import mikanframework.particle.AlgorithmParticle;
import mikanframework.util.ExceptionHelper;
import mikanframework.util.IOHelper;
import mikanframework.util.MapListDeserializer;
import mikanframework.util.ReflectionHelper;

public class ProxyFactory {
    private static final String SPEC_ID = "id";
    private static final String SPEC_CLASS = "class";
    private static final String SPEC_SCOPE = "scope";
    private static final String SPEC_FACTORY = "factory";
    private static final String SPEC_FACTORY_CLASS = "class";
    private static final String SPEC_FACTORY_METHOD = "method";
    private static final String SPEC_CONSTRUCTOR = "constructor";
    private static final String SPEC_CONSTRUCTOR_CLASS = "class";
    private static final String SPEC_CONSTRUCTOR_IMPL = "impl";
    private static final String SPEC_PARTICLE = "particle";
    private static final String SPEC_PARTICLE_CLASS = "class";
    private static final String SPEC_INIT = "init";
    private static final String SPEC_INIT_METHOD = "method";
    private static final String SPEC_INIT_ARGUMENTS = "arguments";
    private static final String SPEC_INIT_ARGUMENTS_CLASS = "class";
    private static final String SPEC_INIT_ARGUMENTS_IMPL = "impl";
    private static final String SPEC_ATTR_SEP = ":";
    private static final String SPEC_ATTR_REF = "ref";
    private static ProxyFactory factory;
    private Map<String, Map<String, Object>> specRegistry = new HashMap<String, Map<String, Object>>();
    private Map<String, Object[]> globalObjectRegistry = new HashMap<String, Object[]>();

    private ProxyFactory() {
    }

    public static ProxyFactory getFactory() {
        factory = factory == null ? new ProxyFactory() : factory;
        return factory;
    }

    public static void clearSpecs() {
        ProxyFactory.getFactory().clearInstanceSpecs();
    }

    private void clearInstanceSpecs() {
        this.specRegistry.clear();
        this.globalObjectRegistry.clear();
    }

    public static void setSpecFromResource(String string) {
        try {
            InputStream inputStream = IOHelper.getResouceInputStream(string);
            Map<String, Object> map = MapListDeserializer.deserializeMapFromTextFile(inputStream);
            if (map == null) {
                return;
            }
            ProxyFactory.setSpec(map);
        }
        catch (Exception exception) {
            throw ExceptionHelper.wrapException(exception);
        }
    }

    public static void setSpec(String string) {
        try {
            File file = new File(string);
            Map<String, Object> map = null;
            map = MapListDeserializer.deserializeMapFromTextFile(file);
            if (map == null) {
                return;
            }
            ProxyFactory.setSpec(map);
        }
        catch (Exception exception) {
            throw ExceptionHelper.wrapException(exception);
        }
    }

    public static void setSpec(Map<String, Object> map) {
        String string = IOHelper.getStringOrDie(map, SPEC_ID, "ID is not defined.");
        ProxyFactory.getFactory().specRegistry.put(string, map);
    }

    public static Object[] createInstances(String string) {
        Object[] objectArray;
        Object[] objectArray2;
        if (ProxyFactory.isGlobalScope(string) && (objectArray2 = ProxyFactory.getFactory().globalObjectRegistry.get(string)) != null && objectArray2.length == 2) {
            return objectArray2;
        }
        objectArray2 = ProxyFactory.getInstanceSpec(string);
        Object object = ProxyFactory.createBaseInstance(objectArray2);
        Object object2 = ProxyFactory.weaveProxySkin((Map<String, Object>)objectArray2, object);
        ProxyFactory.invokeInstanceMethods(object2, (Map<String, Object>)objectArray2);
        if (ProxyFactory.isGlobalScope(string) && (objectArray = ProxyFactory.getFactory().globalObjectRegistry.get(string)) == null) {
            ProxyFactory.getFactory().globalObjectRegistry.put(string, new Object[]{object, object2});
        }
        return new Object[]{object, object2};
    }

    public static Object createInstance(String string) {
        Object object = ProxyFactory.createInstances(string)[1];
        return object;
    }

    protected static Map<String, Object> getInstanceSpec(String string) {
        if (string == null) {
            throw ExceptionHelper.wrapException("ID is null.");
        }
        Map map = (Map)IOHelper.castOrDie(ProxyFactory.getFactory().specRegistry, "");
        Map map2 = (Map)IOHelper.getValueOrDie(map, string, String.format("ID [%s] is not registered.", string));
        if (map2 == null) {
            throw ExceptionHelper.wrapException(String.format("ID [%s] is not registered.", string));
        }
        return map2;
    }

    protected static Object createBaseInstance(Map<String, Object> map) {
        Object object = null;
        String string = IOHelper.getStringOrDie(map, "class", "'class' property is invalid.");
        Class clazz = IOHelper.getClassOrDie(string, "'class' property is invalid.");
        object = map.containsKey(SPEC_FACTORY) ? ProxyFactory.createBaseInstanceWithFactory(map) : ProxyFactory.createBaseInstanceWithConstructor(clazz, map);
        return object;
    }

    protected static Object createBaseInstanceWithFactory(Map<String, Object> map) {
        Object object = null;
        Map map2 = (Map)IOHelper.getValueOrDie(map, SPEC_FACTORY, "'factory' property is invalid.");
        String string = IOHelper.getStringOrDie(map2, "class", "'factory'->'class' property is invalid.");
        Class clazz = IOHelper.getClassOrDie(string, "'factory'->'class' property is invalid.");
        String string2 = IOHelper.getStringOrDie(map2, "method", "'factory'->'method' property is invalid.");
        object = ReflectionHelper.invokeStaticMethod(clazz, string2, new ArrayList(), new ArrayList<Object>());
        return object;
    }

    protected static Object createBaseInstanceWithConstructor(Class<?> clazz, Map<String, Object> map) {
        Object object = null;
        List<Map<String, Object>> list = IOHelper.getMapListOrNew(map, SPEC_CONSTRUCTOR);
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Map<String, Object> map2 : list) {
            String string = IOHelper.getStringOrDie(map2, "class", "'constructor'->'class' property is invalid.");
            Class clazz2 = IOHelper.getClassOrDie(string, "'constructor'->'class' property is invalid.");
            arrayList.add(clazz2);
            String string2 = IOHelper.getStringOrDie(map2, "impl", "'constructor'->'impl' property is invalid.");
            Object object2 = null;
            try {
                object2 = ProxyFactory.resolveAndCreateInstance(string2);
            }
            catch (Exception exception) {
                throw ExceptionHelper.wrapException("'impl'->'impl' property is invalid.", exception);
            }
            arrayList2.add(object2);
        }
        object = ReflectionHelper.newInstanceWithConstructorOrDie(clazz, arrayList, arrayList2);
        return object;
    }

    private static Object weaveProxySkin(Map<String, Object> map, Object object) {
        Object object2;
        if (object == null) {
            throw ExceptionHelper.wrapException("fail to weave particles because base instance is null.");
        }
        ProxySkin proxySkin = new ProxySkin(object);
        List<Map<String, Object>> list = IOHelper.getMapListOrNew(map, SPEC_PARTICLE);
        for (Map<String, Object> object22 : list) {
            String string = IOHelper.getStringOrDie(object22, "class", "'particle'->'class' property is invalid.");
            AlgorithmParticle algorithmParticle = null;
            try {
                algorithmParticle = (AlgorithmParticle)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw ExceptionHelper.wrapException("'particle'->'class' property is invalid.", exception);
            }
            algorithmParticle.setSpec(object22);
            proxySkin.addParticle(algorithmParticle);
        }
        Object var5_6 = null;
        try {
            object2 = Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), (InvocationHandler)proxySkin);
        }
        catch (Exception exception) {
            throw ExceptionHelper.wrapException(String.format("fail to initialize proxy-skin.", new Object[0]), exception);
        }
        return object2;
    }

    protected static void invokeInstanceMethods(Object object, Map<String, Object> map) {
        if (object == null) {
            throw ExceptionHelper.wrapException("fail to call initial methods because base instance is null.");
        }
        List<Map<String, Object>> list = IOHelper.getMapListOrNew(map, SPEC_INIT);
        for (Map<String, Object> map2 : list) {
            ProxyFactory.invokeInstanceOneMethod(map2, object);
        }
    }

    private static void invokeInstanceOneMethod(Map<String, Object> map, Object object) {
        String string = IOHelper.getStringOrDie(map, "method", "'init'->'method' property is invalid.");
        List<Map<String, Object>> list = IOHelper.getMapListOrNew(map, SPEC_INIT_ARGUMENTS);
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Map<String, Object> map2 : list) {
            String string2 = IOHelper.getStringOrDie(map2, "class", "'init'->'arguments'->'class' property is invalid.");
            try {
                arrayList.add(Class.forName(string2));
            }
            catch (Exception exception) {
                throw ExceptionHelper.wrapException(String.format("'init'->'arguments'->'class' [%s] is invalid.", string2), exception);
            }
            String string3 = IOHelper.getStringOrDie(map2, "impl", "'init'->'arguments'->'impl' property is invalid.");
            try {
                Object object2 = ProxyFactory.resolveAndCreateInstance(string3);
                arrayList2.add(object2);
            }
            catch (Exception exception) {
                throw ExceptionHelper.wrapException(String.format("'init'->'arguments'->'impl' [%s] is invalid.", string3), exception);
            }
        }
        ReflectionHelper.invokeObjectMethod(object, string, arrayList, arrayList2);
    }

    private static Object resolveAndCreateInstance(String string) throws Exception {
        Object object = null;
        if (string.startsWith("ref:")) {
            String string2 = string.split(SPEC_ATTR_SEP)[1];
            object = ProxyFactory.createInstance(string2);
        } else {
            object = Class.forName(string).newInstance();
        }
        return object;
    }

    private static boolean isGlobalScope(String string) {
        try {
            return ProxyFactory.getFactory().specRegistry.get(string).get(SPEC_SCOPE).toString().equals("global");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

