//******************************************************************************
//
// OGL Utility / OGLCameraOrtho
//
// 平行投影カメラクラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "OGLTypes.h"
#import "OGLDevice.h"
#include <simd/simd.h>


//******************************************************************************
// 平行投影カメラクラス
//******************************************************************************
class OGLCameraOrtho
{
public:
	
	//コンストラクタ／デストラクタ
	OGLCameraOrtho(void);
	virtual ~OGLCameraOrtho(void);
	
	//更新
	int Transform(OGLDevice* pOGLDevice);
	
private:
	
	matrix_float4x4 _glOrtho(
							OGLfloat left,		//左
							OGLfloat right,		//右
							OGLfloat bottom,	//下
							OGLfloat top,		//上
							OGLfloat near,		//near
							OGLfloat far		//far
						);

};

