//******************************************************************************
//
// MIDITrail / MTColorParamImportDlg
//
// カラーパラメータ入力ダイアログ
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "MTColorParamImportDlg.h"


//##############################################################################
// カラーパラメータ入力ダイアログクラス
//##############################################################################
@implementation MTColorParamImportDlg

//******************************************************************************
// 生成
//******************************************************************************
- (id)init
{
	m_pParamText = nil;
	m_isExecImport = NO;
	
	//Nibファイルを指定してウィンドウコントローラを生成
	return [super initWithWindowNibName:@"ColorParamImportDlg"];
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	[m_pParamText release];
	[super dealloc];
}

//******************************************************************************
// ウィンドウ読み込み完了
//******************************************************************************
- (void)windowDidLoad
{
	int result = 0;
	
	//ウィンドウ表示項目初期化
	//  モーダル終了後に再度モーダル表示してもwindowDidLoadは呼び出されない
	result = [self initDlg];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
}

//******************************************************************************
// モーダルウィンドウ表示
//******************************************************************************
- (void)showModalWindow
{
	m_isExecImport = NO;
	
	//モーダルウィンドウ表示
	[NSApp runModalForWindow:[self window]];
	
	//モーダル表示終了後はウィンドウを非表示にする
	[[self window] orderOut:self];
}

//******************************************************************************
// インポート実行フラグ取得
//******************************************************************************
- (BOOL)isExecImport
{
	return m_isExecImport;
}

//******************************************************************************
// パラメータ文字列取得
//******************************************************************************
- (NSString*)getParamString
{
	NSString* pParamString = nil;
	
	pParamString = [NSString stringWithString:[m_pTextField stringValue]];
	
	return pParamString;
}

//******************************************************************************
// Import ボタン押下
//******************************************************************************
- (IBAction)onBtnImport:(NSButton *)sender
{
	int result = 0;
	
	m_isExecImport = YES;
	
	//ダイアログを閉じる
	[NSApp stopModal];
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// キャンセルボタン押下
//******************************************************************************
- (IBAction)onCancel:(NSButton *)sender
{
	//モーダル表示終了
	[NSApp stopModal];
}

//******************************************************************************
// ペーストボタン押下
//******************************************************************************
- (IBAction)onBtnPaste:(NSButton *)sender
{
	int result = 0;
	NSPasteboard* pPasteboard = nil;
	NSString* pString = nil;
	
	//クリップボードの文字列をテキストフィールドに貼り付ける
	pPasteboard = [NSPasteboard generalPasteboard];
	pString = [pPasteboard stringForType:NSPasteboardTypeString];
	if (pString != nil) {
		[m_pTextField setStringValue:pString];
	}
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// クローズボタン押下
//******************************************************************************
- (void)windowWillClose:(NSNotification*)aNotification
{
	//モーダル表示終了
	[NSApp stopModal];
}

//******************************************************************************
// ダイアログ初期化
//******************************************************************************
- (int)initDlg
{
	int result = 0;
	return result;
}

@end


