//******************************************************************************
//
// MIDITrail / MTColorPalette
//
// カラーパレットクラス
//
// Copyright (C) 2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "SMIDILib.h"
#import "OGLUtil.h"


//******************************************************************************
// カラーパレットクラス
//******************************************************************************
class MTColorPalette
{
public:
	
	//コンストラクタ／デストラクタ
	MTColorPalette(void);
	virtual ~MTColorPalette(void);
	
	//初期化
	int Initialize();
	
	//チャンネル色取得
	int GetChColor(unsigned int chNo, OGLCOLOR* pColor);
	
	//チャンネル色登録
	int SetChColor(unsigned int chNo, OGLCOLOR color);
	
	//背景色取得
	void GetBackgroundColor(OGLCOLOR* pColor);

	//背景色登録
	void SetBackgroundColor(OGLCOLOR color);
	
	//グリッドライン色取得
	void GetGridLineColor(OGLCOLOR* pColor);

	//グリッドライン色登録
	void SetGridLineColor(OGLCOLOR color);
	
	//カウンター色取得
	void GetCounterColor(OGLCOLOR* pColor);

	//カウンター色登録
	void SetCounterColor(OGLCOLOR color);

	//コピー
	int CopyFrom(MTColorPalette* pColorSrc);
	
private:
	
	//代入とコピーコンストラクタの禁止
	void operator=(const MTColorPalette&);
	MTColorPalette(const MTColorPalette&);
	
	OGLCOLOR m_ChColor[SM_MAX_CH_NUM];
	OGLCOLOR m_BgColor;
	OGLCOLOR m_GridLineColor;
	OGLCOLOR m_CounterColor;
	
};


