//******************************************************************************
//
// Simple MIDI Library / SMOutDevCtrl
//
// MIDIo̓foCXNX
//
// Copyright (C) 2010-2021 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

#include "mmsystem.h"
#include <string>
#include <list>

#pragma warning(disable:4251)

namespace SMIDILib {

//******************************************************************************
// p[^`
//******************************************************************************
//ő|[gFA,B,C,D,E,F
#define SM_MIDIOUT_PORT_NUM_MAX   (6)

//******************************************************************************
// MIDIo̓foCXNX
//******************************************************************************
class SMIDILIB_API SMOutDevCtrl
{
public:

	//RXgN^^fXgN^
	SMOutDevCtrl(void);
	virtual ~SMOutDevCtrl(void);

	//
	int Initialize();

	//foCX擾
	unsigned long GetDevNum();

	//foCXv_Ng̎擾
	int GetDevProductName(unsigned long index, std::string& name);

	//|[gΉfoCXo^
	int SetPortDev(unsigned char portNo, const char* pProductName);

	//|[gΉfoCXID擾
	int GetPortDevId(unsigned char portNo, unsigned long* pDevId);

	//SfoCX̃I[v^N[Y
	int OpenPortDevAll();
	int ClosePortDevAll();

	//|[gNA
	int ClearPortInfo();

	//MIDIo̓bZ[WM
	int SendShortMsg(unsigned char portNo, unsigned long msg);
	int SendLongMsg(unsigned char portNo, unsigned char* pMsg, unsigned long size);
	int NoteOffAll();
	int SoundOffAll();

private:

	typedef struct {
		bool isExist;
		unsigned long devId;
		HMIDIOUT hMIDIOut;
	} SMPortInfo;

	SMPortInfo m_PortInfo[SM_MIDIOUT_PORT_NUM_MAX];

	typedef struct {
		unsigned long devId;
		char productName[MAXPNAMELEN];
	} SMOutDevInfo;

	typedef std::list<SMOutDevInfo> SMOutDevList;
	typedef std::list<SMOutDevInfo>::iterator SMOutDevListItr;

	SMOutDevList m_OutDevList;

	int _InitDevList();

	//ƃRs[RXgN^̋֎~
	void operator=(const SMOutDevCtrl&);
	SMOutDevCtrl(const SMOutDevCtrl&);

};

} // end of namespace

#pragma warning(default:4251)

