//******************************************************************************
//
// Simple MIDI Library / SMEventWatcher
//
// CxgEHb`[NX
//
// Copyright (C) 2012-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMEventWatcher.h"
#include "SMEventSysMsg.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMEventWatcher::SMEventWatcher(void)
{
	m_pMsgTrans = NULL;
	_ClearChInfo();
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMEventWatcher::~SMEventWatcher(void)
{
}

//******************************************************************************
// 
//******************************************************************************
int SMEventWatcher::Initialize(SMMsgTransmitter* pMsgTrans)
{
	int result = 0;
	
	m_pMsgTrans = pMsgTrans;
	
	_ClearChInfo();
	
	return result;
}

//******************************************************************************
// CxgEHb`
//******************************************************************************
int SMEventWatcher::WatchEvent(
		unsigned char portNo,
		SMEvent* pEvent
	)
{
	int result = 0;
	SMEventMIDI eventMIDI;
	SMEventSysMsg eventSysMsg;
	
	if (pEvent->GetType() == SMEvent::EventMIDI) {
		eventMIDI.Attach(pEvent);
		
		//MIDICxgĎ
		result = _WatchEventMIDI(portNo, &eventMIDI);
		if (result != 0) goto EXIT;
		
		//Rg[`FWĎ
		if (eventMIDI.GetChMsg() == SMEventMIDI::ControlChange) {
			result = _WatchEventControlChange(portNo, &eventMIDI);
			if (result != 0) goto EXIT;
			result = _WatchEventControlChange2(portNo, &eventMIDI);
			if (result != 0) goto EXIT;
		}
	}
	else if (pEvent->GetType() == SMEvent::EventSysMsg) {
		eventSysMsg.Attach(pEvent);
		
		//VXebZ[WCxgĎ
		result = _WatchEventSysMsg(portNo, &eventSysMsg);
		if (result != 0) goto EXIT;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// MIDICxgEHb`
//******************************************************************************
int SMEventWatcher::WatchEventMIDI(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent
	)
{
	return _WatchEventMIDI(portNo, pMIDIEvent);
}

//******************************************************************************
// Rg[`FWCxgEHb`
//******************************************************************************
int SMEventWatcher::WatchEventControlChange(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent
	)
{
	return _WatchEventControlChange(portNo, pMIDIEvent);
}

//******************************************************************************
// `lNA
//******************************************************************************
void SMEventWatcher::_ClearChInfo()
{
	unsigned long portNo = 0;
	unsigned long chNo = 0;
	
	for (portNo = 0; portNo < SM_MAX_PORT_NUM; portNo++) {
		for (chNo = 0; chNo < SM_MAX_CH_NUM; chNo++) {
			//RPN/NRPNI
			m_RPN_NRPN_Select[portNo][chNo] = RPN_NULL;
			//RPN
			m_RPN_MSB[portNo][chNo] = 0x7F; //RPN NULL
			m_RPN_LSB[portNo][chNo] = 0x7F; //RPN NULL
			//sb`xhx
			m_PitchBendSensitivity[portNo][chNo] = SM_DEFAULT_PITCHBEND_SENSITIVITY;
		}
	}
	
	return;
}

//******************************************************************************
// MIDICxgĎ
//******************************************************************************
int SMEventWatcher::_WatchEventMIDI(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent
	)
{
	int result = 0;
	
	//m[gOFFʒm
	if (pMIDIEvent->GetChMsg() == SMEventMIDI::NoteOff) {
		m_pMsgTrans->PostNoteOff(
				portNo,
				pMIDIEvent->GetChNo(),
				pMIDIEvent->GetNoteNo()
			);
	}
	//m[gONʒm
	else if (pMIDIEvent->GetChMsg() == SMEventMIDI::NoteOn) {
		m_pMsgTrans->PostNoteOn(
				portNo,
				pMIDIEvent->GetChNo(),
				pMIDIEvent->GetNoteNo(),
				pMIDIEvent->GetVelocity()
			);
	}
	//sb`xhʒm
	else if (pMIDIEvent->GetChMsg() == SMEventMIDI::PitchBend) {
		m_pMsgTrans->PostPitchBend(
				portNo,
				pMIDIEvent->GetChNo(),
				pMIDIEvent->GetPitchBendValue(),
				m_PitchBendSensitivity[portNo][pMIDIEvent->GetChNo()]
			);
	}
	
	return result;
}

//******************************************************************************
// Rg[`FWĎ
//******************************************************************************
int SMEventWatcher::_WatchEventControlChange(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent
	)
{
	int result = 0;
	unsigned char msb = 0;
	unsigned char chNo = 0;
	
	chNo = pMIDIEvent->GetChNo();
	
	//----------------------------------------------------------------
	// NRPN MSB / LSB
	//----------------------------------------------------------------
	//NRPN MSB (CC#99)
	if (pMIDIEvent->GetCCNo() == 0x63) {
		m_RPN_NRPN_Select[portNo][chNo] = NRPN;
	}
	//NRPN LSB (CC#98)
	if (pMIDIEvent->GetCCNo() == 0x62) {
		m_RPN_NRPN_Select[portNo][chNo] = NRPN;
	}
	
	//----------------------------------------------------------------
	// RPN MSB / LSB
	//----------------------------------------------------------------
	//RPN MSB (CC#101)
	if (pMIDIEvent->GetCCNo() == 0x65) {
		m_RPN_NRPN_Select[portNo][chNo] = RPN;
		m_RPN_MSB[portNo][chNo] = pMIDIEvent->GetCCValue();
	}
	//RPN LSB (CC#100)
	if (pMIDIEvent->GetCCNo() == 0x64) {
		m_RPN_NRPN_Select[portNo][chNo] = RPN;
		m_RPN_LSB[portNo][chNo] = pMIDIEvent->GetCCValue();
		if ((m_RPN_MSB[portNo][chNo] == 0x7F)
			&& (m_RPN_LSB[portNo][chNo] == 0x7F)) {
			m_RPN_NRPN_Select[portNo][chNo] = RPN_NULL;
		}
	}
	
	//----------------------------------------------------------------
	// Data Entry MSB / LSB
	//----------------------------------------------------------------
	//Data Entry MSB (CC#6)
	if (pMIDIEvent->GetCCNo() == 0x06) {
		//sb`xhx MSB
		if (_GetCurRPNType(portNo, chNo) == PitchBendSensitivity) {
			m_PitchBendSensitivity[portNo][chNo] = pMIDIEvent->GetCCValue();
		}
	}
	//Data Entry LSB (CC#38)
	if (pMIDIEvent->GetCCNo() == 0x26) {
		//ɐȂ
	}
	
	//Data Increment (CC#96)
	if (pMIDIEvent->GetCCNo() == 0x60) {
		//sb`xhx MSB
		if (_GetCurRPNType(portNo, chNo) == PitchBendSensitivity) {
			msb = m_PitchBendSensitivity[portNo][chNo];
			if (msb < 24) {
				m_PitchBendSensitivity[portNo][chNo] = msb++;
			}
		}
	}
	//Data Decremnet (CC#97)
	if (pMIDIEvent->GetCCNo() == 0x61) {
		//sb`xhx MSB
		if (_GetCurRPNType(portNo, chNo) == PitchBendSensitivity) {
			msb = m_PitchBendSensitivity[portNo][chNo]++;
			if (msb > 0) {
				m_PitchBendSensitivity[portNo][chNo] = msb--;
			}
		}
	}
	
	//----------------------------------------------------------------
	// ZbgI[Rg[
	//----------------------------------------------------------------
	//Reset All Controllers (CC#121)
	if (pMIDIEvent->GetCCNo() == 0x79) {
		//sb`xhʒmF0
		m_pMsgTrans->PostPitchBend(portNo, chNo, 0, m_PitchBendSensitivity[portNo][chNo]);
		//RPN/NRPNI
		m_RPN_NRPN_Select[portNo][chNo] = RPN_NULL;
		//RPN
		m_RPN_MSB[portNo][chNo] = 0x7F; //RPN NULL
		m_RPN_LSB[portNo][chNo] = 0x7F; //RPN NULL
		
		//Roland SCV[Y,Yamaha MUV[Y̏ꍇ
		//CC#121 ZbgI[Rg[Ŏ̒lNA
		//  An     |tHjbNL[vbV[  0
		//  Dn     `lvbV[  0
		//  En     sb`xh  0
		//  CC#1   W[V  0
		//  CC#11  GNXvbV  127
		//  CC#64  z[h1    0
		//  CC#65  |^g  0
		//  CC#66  \Xek[g  0
		//  CC#67  \tg  0
		//  CC#98,99   NRPN  ݒԁiݒς݃f[^͕ωȂj
		//  CC#100,101 RPN   ݒԁiݒς݃f[^͕ωȂj
	}
	
	//EXIT:;
	return result;
}

//******************************************************************************
// RPNʎ擾
//******************************************************************************
SMEventWatcher::RPN_Type SMEventWatcher::_GetCurRPNType(
		unsigned char portNo,
		unsigned char chNo
	)
{
	RPN_Type type = RPN_None;
	
	if (m_RPN_NRPN_Select[portNo][chNo] == RPN) {
		if ((m_RPN_MSB[portNo][chNo] == 0x00)
			&& (m_RPN_LSB[portNo][chNo] == 0x00)) {
			type = PitchBendSensitivity;
		}
		if ((m_RPN_MSB[portNo][chNo] == 0x00)
			&& (m_RPN_LSB[portNo][chNo] == 0x01)) {
			type = MasterFineTune;
		}
		if ((m_RPN_MSB[portNo][chNo] == 0x00)
			&& (m_RPN_LSB[portNo][chNo] == 0x02)) {
			type = MasterCourseTune;
		}
	}
	
	return type;
}

//******************************************************************************
// Rg[`FWĎ2
//******************************************************************************
int SMEventWatcher::_WatchEventControlChange2(
		unsigned char portNo,
		SMEventMIDI* pMIDIEvent
	)
{
	int result = 0;
	unsigned char chNo = 0;
	
	chNo = pMIDIEvent->GetChNo();
	
	//ALL SOUND OFF (CC#120)
	//ALL NOTE OFF (CC#123)
	if ((pMIDIEvent->GetCCNo() == 0x78) || (pMIDIEvent->GetCCNo() == 0x7B)) {
		m_pMsgTrans->PostAllNoteOff(portNo, chNo);
	}
	
	return result;
}

//******************************************************************************
// VXebZ[WCxgĎ
//******************************************************************************
int SMEventWatcher::_WatchEventSysMsg(
		unsigned char portNo,
		SMEventSysMsg* pEventSysMsg
	)
{
	int result = 0;

	//͉Ȃ
	goto EXIT;

	switch (pEventSysMsg->GetSysMsg()) {
		case SMEventSysMsg::Common_QuarterFrame:
			OutputDebugString(_T("Common_QuarterFrame\n"));
			break;
		case SMEventSysMsg::Common_SongPositionPointer:
			OutputDebugString(_T("Common_SongPositionPointer\n"));
			break;
		case SMEventSysMsg::Common_SongSelect:
			OutputDebugString(_T("Common_SongSelect\n"));
			break;
		case SMEventSysMsg::Common_TuneRequest:
			OutputDebugString(_T("Common_TuneRequest\n"));
			break;
		case SMEventSysMsg::RealTime_TimingClock:
			OutputDebugString(_T("RealTime_TimingClock\n"));
			break;
		case SMEventSysMsg::RealTime_Start:
			OutputDebugString(_T("RealTime_Start\n"));
			break;
		case SMEventSysMsg::RealTime_Continue:
			OutputDebugString(_T("RealTime_Continue\n"));
			break;
		case SMEventSysMsg::RealTime_Stop:
			OutputDebugString(_T("RealTime_Stop\n"));
			break;
		case SMEventSysMsg::RealTime_ActiveSensing:
			OutputDebugString(_T("RealTime_ActiveSensing\n"));
			break;
		case SMEventSysMsg::RealTime_SystemReset:
			OutputDebugString(_T("RealTime_SystemReset\n"));
			break;
		default:
			break;
	}

EXIT:;
	return result;
}

} // end of namespace


