//******************************************************************************
//
// MIDITrail / MTNoteRainLive
//
// Cuj^pm[gC`NX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// Windowsł̃\[XڐAĂ邽߁AW͍n(DirectX)ŏĂB
// n(DirectX)=>En(OpenGL)ւ̕ϊ LH2RH }NŎB

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTNoteRainLive.h"

using namespace YNBaseLib;


//******************************************************************************
// p[^`
//******************************************************************************
//1m[g̒_ = 1`4_ * 1
#define NOTE_VERTEX_NUM  (4 * 1)

//1m[g̃CfbNX = 1Op`3_ * 2 * 1
#define NOTE_INDEX_NUM   (3 * 2 * 1)

//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteRainLive::MTNoteRainLive(void)
{
	m_NoteNum = 0;
	m_pNoteStatus = NULL;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteRainLive::~MTNoteRainLive(void)
{
	Release();
}

//******************************************************************************
// 
//******************************************************************************
int MTNoteRainLive::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const TCHAR* pSceneName,
		MTNotePitchBend* pNotePitchBend
	)
{
	int result = 0;
	
	Release();
	
	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSceneName, NULL);
	if (result != 0) goto EXIT;
	
	//L[{[hfUCIuWFNg
	result = m_KeyboardDesign.Initialize(pSceneName, NULL);
	if (result != 0) goto EXIT;
	
	//Cuj^\
	m_LiveMonitorDisplayDuration = m_NoteDesign.GetLiveMonitorDisplayDuration();
	
	//m[gz񐶐
	result = _CreateNoteStatus();
	if (result != 0) goto EXIT;
	
	//m[g{bNXiobt@mہj
	result = _CreateNoteRain(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//sb`xh
	m_pNotePitchBend = pNotePitchBend;
	
EXIT:;
	return result;
}

//******************************************************************************
// m[gz񐶐
//******************************************************************************
int MTNoteRainLive::_CreateNoteStatus()
{
	int result = 0;
	unsigned long i = 0;
	
	//m[gz񐶐
	try {
		m_pNoteStatus = new NoteStatus[MTNOTERAIN_MAX_LIVENOTE_NUM];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}
	
	//m[gԃXg
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].portNo = 0;
		m_pNoteStatus[i].chNo = 0;
		m_pNoteStatus[i].noteNo = 0;
		m_pNoteStatus[i].startTime = 0;
		m_pNoteStatus[i].endTime = 0;
	}
	
EXIT:;
	return result;
}

//******************************************************************************
// m[gCiobt@mہj
//******************************************************************************
int MTNoteRainLive::_CreateNoteRain(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTNOTERAIN_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	unsigned long i = 0;
	D3DMATERIAL9 material;
	NoteStatus note;
	
	memset(&note, 0, sizeof(NoteStatus));
	
	//v~eBu
	result = m_PrimitiveNotes.Initialize(
					sizeof(MTNOTERAIN_VERTEX),	//_TCY
					_GetFVFFormat(),			//_FVFtH[}bg
					D3DPT_TRIANGLELIST			//v~eBu
				);
	if (result != 0) goto EXIT;
	
	//_obt@
	vertexNum = NOTE_VERTEX_NUM * MTNOTERAIN_MAX_LIVENOTE_NUM;
	result = m_PrimitiveNotes.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;
	
	//CfbNXobt@
	indexNum = NOTE_INDEX_NUM * MTNOTERAIN_MAX_LIVENOTE_NUM;
	result = m_PrimitiveNotes.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;
	
	//obt@̃bN
	result = m_PrimitiveNotes.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.LockIndex(&pIndex);
	if (result != 0) goto EXIT;
	
	//obt@ɒ_ƃCfbNX
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		result = _CreateVertexOfNote(
						m_pNoteStatus[i],				//m[g
						&(pVertex[NOTE_VERTEX_NUM * i]),//_obt@݈ʒu
						NOTE_VERTEX_NUM * i,			//_obt@CfbNXItZbg
						&(pIndex[NOTE_INDEX_NUM * i]),	//CfbNXobt@݈ʒu
						0								//ݎ
					);
		if (result != 0) goto EXIT;
	}
	
	//obt@̃bN
	result = m_PrimitiveNotes.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.UnlockIndex();
	if (result != 0) goto EXIT;
	
	//}eA쐬
	_MakeMaterial(&material);
	m_PrimitiveNotes.SetMaterial(material);
	
EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTNoteRainLive::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float rollAngle
	)
{
	int result = 0;
	D3DXVECTOR3 moveVector;
	D3DXMATRIX rotateMatrix;
	D3DXMATRIX moveMatrix;
	D3DXMATRIX worldMatrix;
	
	//m[g̒_
	result = _TransformNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//s񏉊
	D3DXMatrixIdentity(&rotateMatrix);
	D3DXMatrixIdentity(&moveMatrix);
	D3DXMatrixIdentity(&worldMatrix);
	
	//]s
	D3DXMatrixRotationY(&rotateMatrix, D3DXToRadian(rollAngle));
	
	//ړs
	//  m[gړꍇ
	moveVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	//  m[gړɃJƃL[{[hړꍇ
	//moveVector = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
	D3DXMatrixTranslation(&moveMatrix, moveVector.x, moveVector.y, moveVector.z);
	
	//s̍Fړ]
	D3DXMatrixMultiply(&worldMatrix, &moveMatrix, &rotateMatrix);
	
	//ϊsݒ
	m_PrimitiveNotes.Transform(worldMatrix);
	
EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_
//******************************************************************************
int MTNoteRainLive::_TransformNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	
	//m[g̏ԍXV
	result = _UpdateStatusOfNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
	//m[g̒_XV
	result = _UpdateVertexOfNotes(pD3DDevice);
	if (result != 0) goto EXIT;
	
EXIT:;
	return result;
}

//******************************************************************************
// m[g̏ԍXV
//******************************************************************************
int MTNoteRainLive::_UpdateStatusOfNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//Âm[gj
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			if ((m_pNoteStatus[i].endTime != 0)
				&& ((curTime - m_pNoteStatus[i].endTime) > m_LiveMonitorDisplayDuration)) {
				m_pNoteStatus[i].isActive = false;
				m_pNoteStatus[i].portNo = 0;
				m_pNoteStatus[i].chNo = 0;
				m_pNoteStatus[i].noteNo = 0;
				m_pNoteStatus[i].startTime = 0;
				m_pNoteStatus[i].endTime = 0;
			}
		}
	}
	
//EXIT:;
	return result;
}

//******************************************************************************
// m[g̒_XV
//******************************************************************************
int MTNoteRainLive::_UpdateVertexOfNotes(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	unsigned long i = 0;
	unsigned long noteNum = 0;
	unsigned long curTime = 0;
	MTNOTERAIN_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	
	curTime = timeGetTime();
	
	//obt@̃bN
	result = m_PrimitiveNotes.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.LockIndex(&pIndex);
	if (result != 0) goto EXIT;
	
	//m[gɂĒ_XV
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			//_XV
			result = _CreateVertexOfNote(
							m_pNoteStatus[i],						//m[g
							&(pVertex[NOTE_VERTEX_NUM * noteNum]),	//_obt@݈ʒu
							NOTE_VERTEX_NUM * noteNum,				//_obt@CfbNXItZbg
							&(pIndex[NOTE_INDEX_NUM * noteNum]),	//CfbNXobt@݈ʒu
							curTime,								//݂̎
							true									//sb`xhKp
						);
			if (result != 0) goto EXIT;
			
			noteNum++;
		}
	}
	m_NoteNum = noteNum;
	
	//obt@̃bN
	result = m_PrimitiveNotes.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_PrimitiveNotes.UnlockIndex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTNoteRainLive::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	DWORD value = 0;
	
	//_OXe[gJOȂɂ
	pD3DDevice->GetRenderState(D3DRS_CULLMODE, &value);
	pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
	
	//m[g̕`
	if (m_NoteNum > 0) {
		result = m_PrimitiveNotes.Draw(
						pD3DDevice,						//foCX
						NULL,							//eNX`FȂ
						(NOTE_INDEX_NUM/3)*m_NoteNum	//v~eBu
					);
		if (result != 0) goto EXIT;
	}
	
	//_OXe[g߂
	pD3DDevice->SetRenderState(D3DRS_CULLMODE, value);
	
EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTNoteRainLive::Release()
{
	m_PrimitiveNotes.Release();
	
	delete [] m_pNoteStatus;
	m_pNoteStatus = NULL;
}

//******************************************************************************
// m[gC̒_
//******************************************************************************
int MTNoteRainLive::_CreateVertexOfNote(
		NoteStatus note,
		MTNOTERAIN_VERTEX* pVertex,
		unsigned long vertexOffset,
		unsigned long* pIndex,
		unsigned long curTime,
		bool isEnablePitchBend
	)
{
	int result = 0;
	D3DXVECTOR3 startVector;
	D3DXVECTOR3 endVector;
	D3DXVECTOR3 moveVector;
	D3DXCOLOR color;
	float rainWidth = m_KeyboardDesign.GetBlackKeyWidth();
	float pitchBendShift = 0.0f;
	short pitchBendValue = 0;
	unsigned char pitchBendSensitivity = SM_DEFAULT_PITCHBEND_SENSITIVITY;
	unsigned long elapsedTime = 0;
	
	if ((isEnablePitchBend) && (note.endTime == 0)) {
		pitchBendValue =       m_pNotePitchBend->GetValue(note.portNo, note.chNo);
		pitchBendSensitivity = m_pNotePitchBend->GetSensitivity(note.portNo, note.chNo);
		pitchBendShift = m_KeyboardDesign.GetPitchBendShift(pitchBendValue, pitchBendSensitivity);
	}
	
	//m[gONW
	elapsedTime = curTime - note.startTime;
	if (elapsedTime > m_LiveMonitorDisplayDuration) {
		elapsedTime = m_LiveMonitorDisplayDuration;
	}
	startVector.x = pitchBendShift;
	startVector.y = m_NoteDesign.GetLivePosX(elapsedTime);
	startVector.z = 0.0f;
	
	//m[gOFFW
	elapsedTime = 0;
	if (note.endTime != 0) {
		elapsedTime = curTime - note.endTime;
	}
	endVector.x = pitchBendShift;
	endVector.y = m_NoteDesign.GetLivePosX(elapsedTime);
	endVector.z = 0.0f;
	
	//ړxNg
	moveVector    = m_KeyboardDesign.GetKeyboardBasePos(note.portNo, note.chNo);
	moveVector.x += m_KeyboardDesign.GetKeyCenterPosX(note.noteNo);
	moveVector.y += m_KeyboardDesign.GetWhiteKeyHeight() / 2.0f;
	moveVector.z += m_KeyboardDesign.GetNoteDropPosZ(note.noteNo);
	
	//WXV
	startVector = startVector + moveVector;
	endVector   = endVector   + moveVector;
	
	//_
	pVertex[0].p = D3DXVECTOR3(startVector.x - rainWidth/2.0f, startVector.y, startVector.z);
	pVertex[1].p = D3DXVECTOR3(startVector.x + rainWidth/2.0f, startVector.y, startVector.z);
	pVertex[2].p = D3DXVECTOR3(endVector.x   + rainWidth/2.0f, endVector.y,   endVector.z);
	pVertex[3].p = D3DXVECTOR3(endVector.x   - rainWidth/2.0f, endVector.y,   endVector.z);
	
	//@
	//ۂ̖ʂ̕ɍ킹(0,0,-1)ƂƃCgKpƂɈÂȂ
	//Ղ̏ʂɍ킹邱ƂŖ邭
	pVertex[0].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
	pVertex[1].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
	pVertex[2].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
	pVertex[3].n = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
	
	//F
	color = m_NoteDesign.GetNoteBoxColor(note.portNo, note.chNo, note.noteNo);
	pVertex[0].c = D3DXCOLOR(color.r, color.g, color.b, 1.0f);
	pVertex[1].c = D3DXCOLOR(color.r, color.g, color.b, 1.0f);
	pVertex[2].c = D3DXCOLOR(color.r, color.g, color.b, 0.5f); //m[gOFFɋ߂Âقǔɂ
	pVertex[3].c = D3DXCOLOR(color.r, color.g, color.b, 0.5f); //m[gOFFɋ߂Âقǔɂ
	
	//CfbNX
	pIndex[0] = vertexOffset + 0;
	pIndex[1] = vertexOffset + 2;
	pIndex[2] = vertexOffset + 1;
	pIndex[3] = vertexOffset + 0;
	pIndex[4] = vertexOffset + 3;
	pIndex[5] = vertexOffset + 2;
	
	return result;
}

//******************************************************************************
// }eA쐬
//******************************************************************************
void MTNoteRainLive::_MakeMaterial(
		D3DMATERIAL9* pMaterial
	)
{
	memset(pMaterial, 0, sizeof(D3DMATERIAL9));
	
	//gU
	pMaterial->Diffuse.r = 1.0f;
	pMaterial->Diffuse.g = 1.0f;
	pMaterial->Diffuse.b = 1.0f;
	pMaterial->Diffuse.a = 1.0f;
	//Fe̐F
	pMaterial->Ambient.r = 0.5f;
	pMaterial->Ambient.g = 0.5f;
	pMaterial->Ambient.b = 0.5f;
	pMaterial->Ambient.a = 1.0f;
	//ʔˌ
	pMaterial->Specular.r = 0.2f;
	pMaterial->Specular.g = 0.2f;
	pMaterial->Specular.b = 0.2f;
	pMaterial->Specular.a = 1.0f;
	//ʔˌ̑Nx
	pMaterial->Power = 40.0f;
	//F
	pMaterial->Emissive.r = 0.0f;
	pMaterial->Emissive.g = 0.0f;
	pMaterial->Emissive.b = 0.0f;
	pMaterial->Emissive.a = 0.0f;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTNoteRainLive::Reset()
{
	unsigned long i = 0;
	
	m_NoteNum = 0;
	
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		m_pNoteStatus[i].isActive = false;
		m_pNoteStatus[i].portNo = 0;
		m_pNoteStatus[i].chNo = 0;
		m_pNoteStatus[i].noteNo = 0;
		m_pNoteStatus[i].startTime = 0;
		m_pNoteStatus[i].endTime = 0;
	}
	
	return;
}

//******************************************************************************
// m[gONo^
//******************************************************************************
void MTNoteRainLive::SetNoteOn(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		unsigned char velocity
	)
{
	unsigned long i = 0;
	unsigned long cleardIndex = 0;
	bool isFind = false;
	unsigned long curTime = 0;
	
	curTime = timeGetTime();
	
	//󂫃Xy[XɃm[go^
	//󂫂ȂΓo^߂
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			if ((m_pNoteStatus[i].endTime != 0)
				&& ((curTime - m_pNoteStatus[i].endTime) > m_LiveMonitorDisplayDuration)) {
				m_pNoteStatus[i].isActive = false;
				cleardIndex = i;
				isFind = true;
				break;
			}
		}
		else {
			m_pNoteStatus[i].isActive = false;
			cleardIndex = i;
			isFind = true;
			break;
		}
	}
	
	//󂫃Xy[XȂꍇ͍łÂm[gNA
	if (!isFind) {
		_ClearOldestNoteStatus(&cleardIndex);
	}
	
	//m[go^
	m_pNoteStatus[cleardIndex].isActive = true;
	m_pNoteStatus[cleardIndex].portNo = portNo;
	m_pNoteStatus[cleardIndex].chNo = chNo;
	m_pNoteStatus[cleardIndex].noteNo = noteNo;
	m_pNoteStatus[cleardIndex].startTime = timeGetTime();
	m_pNoteStatus[cleardIndex].endTime = 0;
	
	return;
}

//******************************************************************************
// m[gOFFo^
//******************************************************************************
void MTNoteRainLive::SetNoteOff(
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo
	)
{
	unsigned long i = 0;
	
	//Ỹm[gɏIݒ
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		if ((m_pNoteStatus[i].isActive)
			&& (m_pNoteStatus[i].portNo == portNo)
			&& (m_pNoteStatus[i].chNo == chNo)
			&& (m_pNoteStatus[i].noteNo == noteNo)
			&& (m_pNoteStatus[i].endTime == 0)) {
			m_pNoteStatus[i].endTime = timeGetTime();
			break;
		}
	}
	
	return;
}

//******************************************************************************
// Sm[gOFF
//******************************************************************************
void MTNoteRainLive::AllNoteOff()
{
	unsigned long i = 0;
	
	//m[gOFFݒ肳ĂȂm[gɏIݒ
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		if ((m_pNoteStatus[i].isActive) && (m_pNoteStatus[i].endTime == 0)) {
			m_pNoteStatus[i].endTime = timeGetTime();
		}
	}
	
	return;
}

//******************************************************************************
// Sm[gOFFi`lwj
//******************************************************************************
void MTNoteRainLive::AllNoteOffOnCh(
		unsigned char portNo,
		unsigned char chNo
	)
{
	unsigned long i = 0;
	
	//w`lŃm[gOFFݒ肳ĂȂm[gɏIݒ
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		if ((m_pNoteStatus[i].isActive) && (m_pNoteStatus[i].endTime == 0)
			&& (m_pNoteStatus[i].portNo == portNo) && (m_pNoteStatus[i].chNo == chNo)) {
			m_pNoteStatus[i].endTime = timeGetTime();
		}
	}
	
	return;
}

//******************************************************************************
// łÂm[g̃NA
//******************************************************************************
void MTNoteRainLive::_ClearOldestNoteStatus(
		unsigned long* pCleardIndex
	)
{
	unsigned long i = 0;
	unsigned long oldestIndex = 0;
	bool isFind = false;
	
	//m[gONłÂm[gNA
	for (i = 0; i < MTNOTERAIN_MAX_LIVENOTE_NUM; i++) {
		if (m_pNoteStatus[i].isActive) {
			if (!isFind) {
				//Lȃm[gꂽꍇF
				oldestIndex = i;
				isFind = true;
			}
			else {
				//Lȃm[gꂽꍇF2ڈȍ~
				if (m_pNoteStatus[i].startTime < m_pNoteStatus[oldestIndex].startTime) {
					oldestIndex = i;
				}
			}
		}
	}
	
	//m[gNA
	//  m[go^ĂȂꍇ͔z̐擪NAΏۂƂȂ
	m_pNoteStatus[oldestIndex].isActive = false;
	*pCleardIndex = oldestIndex;
	
	return;
}

