//******************************************************************************
//
// Simple MIDI Library / SMSeqData
//
// シーケンスデータクラス
//
// Copyright (C) 2010-2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "SMCommon.h"
#import "SMTrack.h"
#import "SMBarList.h"
#import "SMPortList.h"
#import <list>


#pragma warning(disable:4251)

//******************************************************************************
// シーケンスデータクラス
//******************************************************************************
class SMSeqData
{
public:
	
	//コンストラクタ／デストラクタ
	SMSeqData();
	virtual ~SMSeqData(void);
	
	//----------------------------------------------------------------
	//データ作成系
	//----------------------------------------------------------------
	//エンコーディングID登録（NSStringEncoding）
	void SetEncodingId(NSStringEncoding encodingId);
	
	//SMFフォーマット登録
	void SetSMFFormat(unsigned short smfFormat);
	
	//時間解像度登録
	void SetTimeDivision(unsigned int timeDivision);
	
	//トラック登録
	int AddTrack(SMTrack* pTrack);
	
	//トラック登録終了
	int CloseTrack();
	
	//ファイル名登録
	void SetFileName(NSString* const pFileName);
	
	//クリア
	void Clear();
	
	//----------------------------------------------------------------
	//データ取得系
	//----------------------------------------------------------------
	//SMFフォーマット取得
	unsigned short GetSMFFormat();
	
	//時間解像度取得
	unsigned int GetTimeDivision();
	
	//トラック数取得
	unsigned int GetTrackNum();
	
	//トラック取得
	int GetTrack(unsigned int index, SMTrack* pTrack);
	
	//マージ済みトラック取得
	int GetMergedTrack(SMTrack* pMergedTrack);
	
	//トータルチックタイム取得
	unsigned int GetTotalTickTime();
	
	//トータル演奏時間取得
	unsigned int GetTotalPlayTime();
	
	//テンポ取得
	unsigned int GetTempo();
	
	//テンポ取得(BPM)
	unsigned int GetTempoBPM();
	
	//拍子記号取得：分子と分母
	unsigned int GetBeatNumerator();
	unsigned int GetBeatDenominator();
	
	//小節数取得
	unsigned int GetBarNum();
	
	//コピーライト文字列取得
	NSString* GetCopyRight();
	
	//タイトル文字列取得
	NSString* GetTitle();
	
	//小節リスト取得
	int GetBarList(SMBarList* pBarList);
	
	//ポートリスト取得
	int GetPortList(SMPortList* pPortList);
	
	//ファイル名取得
	const NSString* GetFileName();
	
private:
	
	typedef std::list<SMTrack*> SMTrackList;
	typedef std::list<SMTrack*>::iterator SMTrackListItr;
	
	typedef struct {
		unsigned int index;
		unsigned int deltaTime;
	} SMDeltaTimeBuf;
	
	typedef std::list<SMDeltaTimeBuf> SMDeltaTimeBufList;
	typedef std::list<SMDeltaTimeBuf>::iterator SMDeltaTimeBufListItr;
	
private:
	
	NSStringEncoding m_EncodingId;
	unsigned int m_SMFFormat;
	unsigned int m_TimeDivision;
	unsigned int m_TotalTickTime;
	unsigned int m_TotalPlayTime;
	unsigned int m_Tempo;
	unsigned int m_BeatNumerator;
	unsigned int m_BeatDenominator;
	unsigned int m_BarNum;
	NSString* m_pStrCopyRight;
	NSString* m_pStrTitle;
	NSString* m_pStrFileName;
	SMTrackList m_TrackList;
	SMTrack* m_pMergedTrack;
	
	int _MergeTracks();
	double _GetDeltaTimeMsec(unsigned int tempo, unsigned int deltaTime);
	int _GetTempo(unsigned int* pTempo);
	int _GetBeat(unsigned int* pNumerator, unsigned int* pDenominator);
	int _GetBarNum(unsigned int* pBarNum);
	int _CalcTotalTime();
	int _SearchText();
	
	//代入とコピーコンストラクタの禁止
	void operator=(const SMSeqData&);
	SMSeqData(const SMSeqData&);

};

#pragma warning(default:4251)


