//******************************************************************************
//
// MIDItrail / MTSceneMsg
//
// シーンメッセージクラス
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>
#import "DIMouseCtrl.h"
#import "MTScene.h"


//******************************************************************************
//メッセージID
//******************************************************************************
typedef int MTSceneMsgId;
#define MTSCENEMSG_PLAY_START		(1)		//演奏開始
#define MTSCENEMSG_PLAY_END			(2)		//演奏終了
#define MTSCENEMSG_REWIND			(3)		//巻き戻し
#define MTSCENEMSG_RESET_VIEWPOINT	(4)		//視点リセット
#define MTSCENEMSG_SET_VIEWPOINT	(5)		//視点登録
#define MTSCENEMSG_GET_VIEWPOINT	(6)		//視点取得
#define MTSCENEMSG_SET_EFFECT		(7)		//エフェクト設定
#define MTSCENEMSG_ON_MOUSE_CLICK	(8)		//マウスクリックイベント
#define MTSCENEMSG_ON_MOUSE_WHEEL	(9)		//マウスホイールイベント
#define MTSCENEMSG_STOP_SCENE		(10)	//シーン停止
#define MTSCENEMSG_ON_GAMECONTROLLER_CHANGED	(11)	//ゲームコントローラー更新


//******************************************************************************
// シーンメッセージクラス
//******************************************************************************
class MTSceneMsg
{
public:
	
	//コンストラクタ／デストラクタ
	MTSceneMsg(MTSceneMsgId msgId);
	virtual ~MTSceneMsg(void);
	
	//メッセージID取得
	MTSceneMsgId GetMsgId();
	
	//同期モード設定
	void SetSyncMode(bool isSync);
	
	//同期モード判定
	bool IsSyncMode();
	
	//処理応答待機
	void WaitAns();
	
	//処理終了応答
	void WakeUp();
	
private:
	
	int m_MsgId;
	NSCondition* m_pCondition;
	
	//代入とコピーコンストラクタの禁止
	void operator=(const MTSceneMsg&);
	MTSceneMsg(const MTSceneMsg&);
	
};

//******************************************************************************
// シーンメッセージクラス：演奏開始
//******************************************************************************
class MTSceneMsgPlayStart : public MTSceneMsg
{
public:
	
	MTSceneMsgPlayStart(void);
	virtual ~MTSceneMsgPlayStart(void);
	
};

//******************************************************************************
// シーンメッセージクラス：演奏終了
//******************************************************************************
class MTSceneMsgPlayEnd : public MTSceneMsg
{
public:
	
	MTSceneMsgPlayEnd(void);
	virtual ~MTSceneMsgPlayEnd(void);
	
};

//******************************************************************************
// シーンメッセージクラス：巻き戻し
//******************************************************************************
class MTSceneMsgRewind : public MTSceneMsg
{
public:
	
	MTSceneMsgRewind(void);
	virtual ~MTSceneMsgRewind(void);
	
};

//******************************************************************************
// シーンメッセージクラス：視点リセット
//******************************************************************************
class MTSceneMsgResetViewpoint : public MTSceneMsg
{
public:
	
	MTSceneMsgResetViewpoint(void);
	virtual ~MTSceneMsgResetViewpoint(void);
	
};

//******************************************************************************
// シーンメッセージクラス：視点登録
//******************************************************************************
class MTSceneMsgSetViewpoint : public MTSceneMsg
{
public:

	MTSceneMsgSetViewpoint(void);
	virtual ~MTSceneMsgSetViewpoint(void);
	
	MTScene::MTViewParamMap* GetViewParamMapPtr();
	
private:
	
	MTScene::MTViewParamMap m_ViewParamMap;
	
};

//******************************************************************************
// シーンメッセージクラス：視点取得
//******************************************************************************
class MTSceneMsgGetViewpoint : public MTSceneMsg
{
public:
	
	MTSceneMsgGetViewpoint(void);
	virtual ~MTSceneMsgGetViewpoint(void);
	
	MTScene::MTViewParamMap* GetViewParamMapPtr();
	
private:
	
	MTScene::MTViewParamMap m_ViewParamMap;
	
};

//******************************************************************************
// シーンメッセージクラス：エフェクト設定
//******************************************************************************
class MTSceneMsgSetEffect : public MTSceneMsg
{
public:
	
	MTSceneMsgSetEffect(void);
	virtual ~MTSceneMsgSetEffect(void);
	
	void SetEffect(MTScene::EffectType type, bool isEnable);
	void GetEffect(MTScene::EffectType* pType, bool* pIsEnable);
	
private:
	
	MTScene::EffectType m_EffectType;
	bool m_isEnable;
	
};

//******************************************************************************
// シーンメッセージクラス：マウスクリックイベント
//******************************************************************************
class MTSceneMsgOnMouseClick : public MTSceneMsg
{
public:
	
	MTSceneMsgOnMouseClick(void);
	virtual ~MTSceneMsgOnMouseClick(void);
	
	void SetClickButton(unsigned int button);
	unsigned int GetClickButton();
	
private:
	
	unsigned int m_MouseButton;
	
};

//******************************************************************************
// シーンメッセージクラス：マウスホイールイベント
//******************************************************************************
class MTSceneMsgOnMouseWheel : public MTSceneMsg
{
public:
	
	MTSceneMsgOnMouseWheel(void);
	virtual ~MTSceneMsgOnMouseWheel(void);
	
	void SetWheelDelta(float deltaWheelX, float deltaWheelY, float deltaWheelZ);
	void GetWheelDelta(float* pDeltaWheelX, float* pDeltaWheelY, float* pDeltaWheelZ);
	
private:
	
	float m_DeltaWheelX;
	float m_DeltaWheelY;
	float m_DeltaWheelZ;
	
};

//******************************************************************************
// シーンメッセージクラス：ゲームコントローラー更新イベント
//******************************************************************************
class MTSceneMsgOnGameControllerChanged : public MTSceneMsg
{
public:
	
	MTSceneMsgOnGameControllerChanged(void);
	virtual ~MTSceneMsgOnGameControllerChanged(void);
	
};


