//******************************************************************************
//
// MIDITrail / MTNoteDesignRing
//
// ノートデザインリングクラス
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MTNoteDesign.h"


//******************************************************************************
// ノートデザインクラス
//******************************************************************************
class MTNoteDesignRing : public MTNoteDesign
{
public:

	//コンストラクタ／デストラクタ
	MTNoteDesignRing(void);
	virtual ~MTNoteDesignRing(void);
	
	//ライブモニタモード設定
	void SetLiveMode(void);
	
	//ノートボックス中心座標取得
	virtual OGLVECTOR3 GetNoteBoxCenterPosX(
				unsigned int curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				short pitchBendValue = 0,				//省略可：ピッチベンド
				unsigned char pitchBendSensitivity = 0	//省略可：ピッチベンド感度
			);

	//ノートボックス頂点座標取得
	virtual void GetNoteBoxVirtexPos(
				unsigned int curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				OGLVECTOR3* pVector0,	//YZ平面+X軸方向を見て左上
				OGLVECTOR3* pVector1,	//YZ平面+X軸方向を見て右上
				OGLVECTOR3* pVector2,	//YZ平面+X軸方向を見て左下
				OGLVECTOR3* pVector3,	//YZ平面+X軸方向を見て右下
				short pitchBendValue = 0,				//省略可：ピッチベンド
				unsigned char pitchBendSensitivity = 0	//省略可：ピッチベンド感度
			);

	//発音中ノートボックス頂点座標取得
	virtual void GetActiveNoteBoxVirtexPos(
				unsigned int curTickTime,
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				OGLVECTOR3* pVector0,	//YZ平面+X軸方向を見て左上
				OGLVECTOR3* pVector1,	//YZ平面+X軸方向を見て右上
				OGLVECTOR3* pVector2,	//YZ平面+X軸方向を見て左下
				OGLVECTOR3* pVector3,	//YZ平面+X軸方向を見て右下
				short pitchBendValue = 0,				//省略可：ピッチベンド
				unsigned char pitchBendSensitivity = 0,	//省略可：ピッチベンド感度
				unsigned int elapsedTime = 0            //省略可：経過時間（ミリ秒）
			);

	//ライブモニタ用ノートボックス頂点座標取得
	virtual void GetNoteBoxVirtexPosLive(
				unsigned int elapsedTime,	//経過時間（ミリ秒）
				unsigned char portNo,
				unsigned char chNo,
				unsigned char noteNo,
				OGLVECTOR3* pVector0,	//YZ平面+X軸方向を見て左上
				OGLVECTOR3* pVector1,	//YZ平面+X軸方向を見て右上
				OGLVECTOR3* pVector2,	//YZ平面+X軸方向を見て左下
				OGLVECTOR3* pVector3,	//YZ平面+X軸方向を見て右下
				short pitchBendValue = 0,				//省略可：ピッチベンド
				unsigned char pitchBendSensitivity = 0	//省略可：ピッチベンド感度
			);

	//グリッドリング基準座標取得
	void GetGridRingBasePos(
			unsigned int totalTickTime,
			OGLVECTOR3* pBasePosStart,
			OGLVECTOR3* pBasePosEnd
		);

	//ライブモニタ用グリッドリング基準座標取得
	void GetGridRingBasePosLive(
			OGLVECTOR3* pBasePosStart,
			OGLVECTOR3* pBasePosEnd
		);

	//ポート原点座標取得
	virtual float GetPortOriginY(unsigned char portNo);
	virtual float GetPortOriginZ(unsigned char portNo);

	//世界座標配置移動ベクトル取得
	virtual OGLVECTOR3 GetWorldMoveVector();

private:

	bool m_isLiveMode;
	float m_NoteAngleStep;
	float m_RingRadius;

	// ノート基準座標取得
	OGLVECTOR3 _GetNoteBasePos(
			unsigned int curTickTime,
			unsigned char portNo,
			unsigned char chNo
		);

	// ノート角度取得
	float _GetNoteAngle(
			unsigned char noteNo,
			short pitchBendValue,				//省略可：ピッチベンド
			unsigned char pitchBendSensitivity	//省略可：ピッチベンド感度
		);

	virtual int _LoadConfFile(NSString* pSceneName);

};


