//******************************************************************************
//
// MIDITrail / MTNoteDesignRing
//
// m[gfUCONX
//
// Copyright (C) 2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


#import "YNBaseLib.h"
#import "OGLUtil.h"
#import "MTParam.h"
#import "MTConfFile.h"
#import "MTNoteDesignRing.h"


//******************************************************************************
// RXgN^
//******************************************************************************
MTNoteDesignRing::MTNoteDesignRing(void)
{
	m_isLiveMode = false;
	m_NoteAngleStep = 360.0f / (float)SM_MAX_NOTE_NUM;
	m_RingRadius = 0.0f;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTNoteDesignRing::~MTNoteDesignRing(void)
{
}

//******************************************************************************
// Cuj^[hݒ
//******************************************************************************
void MTNoteDesignRing::SetLiveMode(void)
{
	m_isLiveMode = true;
}

//******************************************************************************
// m[g{bNXSW擾
//******************************************************************************
OGLVECTOR3 MTNoteDesignRing::GetNoteBoxCenterPosX(
		unsigned int curTickTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		short pitchBendValue,				//ȗFsb`xh
		unsigned char pitchBendSensitivity	//ȗFsb`xhx
	)
{
	OGLVECTOR3 basePos;
	OGLVECTOR3 notePos;
	float angle = 0.0f;

	//m[gW
	basePos = _GetNoteBasePos(curTickTime, portNo, chNo);

	//m[gԍŊpx
	angle = _GetNoteAngle(noteNo, pitchBendValue, pitchBendSensitivity);

	//X]
	notePos = OGLH::RotateYZ(0.0f, 0.0f, basePos, angle);

	return notePos;
}

//******************************************************************************
// m[g{bNX_W擾
//******************************************************************************
void MTNoteDesignRing::GetNoteBoxVirtexPos(
		unsigned int curTickTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		OGLVECTOR3* pVector0,	//YZ+Xč
		OGLVECTOR3* pVector1,	//YZ+XĉE
		OGLVECTOR3* pVector2,	//YZ+Xč
		OGLVECTOR3* pVector3,	//YZ+XĉE
		short pitchBendValue,				//ȗFsb`xh
		unsigned char pitchBendSensitivity	//ȗFsb`xhx

	)
{
	OGLVECTOR3 basePos0;
	OGLVECTOR3 basePos1;
	OGLVECTOR3 basePos2;
	float angle0 = 0.0f;
	float angle1 = 0.0f;
	float angle2 = 0.0f;

	//m[gW
	basePos0 = _GetNoteBasePos(curTickTime, portNo, chNo);
	basePos1 = basePos0;
	basePos1.y -= GetNoteBoxWidth() / 2.0f;
	basePos2 = basePos0;
	basePos2.y += GetNoteBoxWidth() / 2.0f;

	//m[gԍŊpx
	angle0 = _GetNoteAngle(noteNo, pitchBendValue, pitchBendSensitivity);
	angle1 = angle0 - (m_NoteAngleStep / 2.0f);
	angle2 = angle0 + (m_NoteAngleStep / 2.0f);

	*pVector0 = OGLH::RotateYZ(0.0f, 0.0f, basePos2, angle1);
	*pVector1 = OGLH::RotateYZ(0.0f, 0.0f, basePos2, angle2);
	*pVector2 = OGLH::RotateYZ(0.0f, 0.0f, basePos1, angle1);
	*pVector3 = OGLH::RotateYZ(0.0f, 0.0f, basePos1, angle2);
}

//******************************************************************************
// m[g{bNX_W擾
//******************************************************************************
void MTNoteDesignRing::GetActiveNoteBoxVirtexPos(
		unsigned int curTickTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		OGLVECTOR3* pVector0,	//YZ+Xč
		OGLVECTOR3* pVector1,	//YZ+XĉE
		OGLVECTOR3* pVector2,	//YZ+Xč
		OGLVECTOR3* pVector3,	//YZ+XĉE
		short pitchBendValue,				//ȗFsb`xh
		unsigned char pitchBendSensitivity,	//ȗFsb`xhx
		unsigned int elapsedTime			//ȗFoߎԁi~bj
	)
{
	OGLVECTOR3 basePos0;
	OGLVECTOR3 basePos1;
	OGLVECTOR3 basePos2;
	float angle0 = 0.0f;
	float angle1 = 0.0f;
	float angle2 = 0.0f;
	float curSizeRatio = 1.0f;

	if (elapsedTime < (unsigned int)m_ActiveNoteDuration) {
		curSizeRatio = 1.0f + (m_ActiveNoteBoxSizeRatio - 1.0f) * (1.0f - (float)elapsedTime / (float)m_ActiveNoteDuration);
	}

	//m[gW
	basePos0 = _GetNoteBasePos(curTickTime, portNo, chNo);
	basePos1 = basePos0;
	basePos1.y -= GetNoteBoxWidth() * curSizeRatio / 2.0f;
	basePos2 = basePos0;
	basePos2.y += GetNoteBoxWidth() * curSizeRatio / 2.0f;

	//m[gԍŊpx
	angle0 = _GetNoteAngle(noteNo, pitchBendValue, pitchBendSensitivity);
	angle1 = angle0 - (m_NoteAngleStep * curSizeRatio / 2.0f);
	angle2 = angle0 + (m_NoteAngleStep * curSizeRatio / 2.0f);

	*pVector0 = OGLH::RotateYZ(0.0f, 0.0f, basePos2, angle1);
	*pVector1 = OGLH::RotateYZ(0.0f, 0.0f, basePos2, angle2);
	*pVector2 = OGLH::RotateYZ(0.0f, 0.0f, basePos1, angle1);
	*pVector3 = OGLH::RotateYZ(0.0f, 0.0f, basePos1, angle2);
}

//******************************************************************************
// Cuj^pm[g{bNX_W擾
//******************************************************************************
void MTNoteDesignRing::GetNoteBoxVirtexPosLive(
		unsigned int elapsedTime,
		unsigned char portNo,
		unsigned char chNo,
		unsigned char noteNo,
		OGLVECTOR3* pVector0,	//YZ+Xč
		OGLVECTOR3* pVector1,	//YZ+XĉE
		OGLVECTOR3* pVector2,	//YZ+Xč
		OGLVECTOR3* pVector3,	//YZ+XĉE
		short pitchBendValue,				//ȗFsb`xh
		unsigned char pitchBendSensitivity	//ȗFsb`xhx
	)
{
	OGLVECTOR3 basePos0;
	OGLVECTOR3 basePos1;
	OGLVECTOR3 basePos2;
	float angle0 = 0.0f;
	float angle1 = 0.0f;
	float angle2 = 0.0f;
	float x = 0.0f;
	unsigned int tickTimeDummy = 0;

	x = -(GetLivePosX(elapsedTime));

	//m[gW
	basePos0 = _GetNoteBasePos(tickTimeDummy, portNo, chNo);
	basePos0.x = x;
	basePos1 = basePos0;
	basePos1.y -= GetNoteBoxWidth() / 2.0f;
	basePos2 = basePos0;
	basePos2.y += GetNoteBoxWidth() / 2.0f;

	//m[gԍŊpx
	angle0 = _GetNoteAngle(noteNo, pitchBendValue, pitchBendSensitivity);
	angle1 = angle0 - (m_NoteAngleStep / 2.0f);
	angle2 = angle0 + (m_NoteAngleStep / 2.0f);

	*pVector0 = OGLH::RotateYZ(0.0f, 0.0f, basePos2, angle1);
	*pVector1 = OGLH::RotateYZ(0.0f, 0.0f, basePos2, angle2);
	*pVector2 = OGLH::RotateYZ(0.0f, 0.0f, basePos1, angle1);
	*pVector3 = OGLH::RotateYZ(0.0f, 0.0f, basePos1, angle2);
}

//******************************************************************************
// ObhOW擾
//******************************************************************************
void MTNoteDesignRing::GetGridRingBasePos(
		unsigned int totalTickTime,
		OGLVECTOR3* pBasePosStart,
		OGLVECTOR3* pBasePosEnd
	)
{
	*pBasePosStart = OGLVECTOR3(
							GetPlayPosX(0),
							GetPortOriginY(0),
							GetPortOriginZ(0));
	*pBasePosEnd   = OGLVECTOR3(
							GetPlayPosX(totalTickTime),
							GetPortOriginY(0),
							GetPortOriginZ(0));
}

//******************************************************************************
// Cuj^pObhOW擾
//******************************************************************************
void MTNoteDesignRing::GetGridRingBasePosLive(
		OGLVECTOR3* pBasePosStart,
		OGLVECTOR3* pBasePosEnd
	)
{
	unsigned int elapsedTime = 0;

	elapsedTime = GetLiveMonitorDisplayDuration();
	*pBasePosStart = OGLVECTOR3(
							GetPlayPosX(0),
							GetPortOriginY(0),
							GetPortOriginZ(0));
	*pBasePosEnd   = OGLVECTOR3(
							-(GetLivePosX(elapsedTime)),
							GetPortOriginY(0),
							GetPortOriginZ(0));
}

//******************************************************************************
// |[g_YW擾
//******************************************************************************
float MTNoteDesignRing::GetPortOriginY(
		unsigned char portNo
	)
{
	float portIndex = 0.0f;
	float portWidth = 0.0f;

	portIndex = (float)(m_PortIndex[portNo]);
	portWidth = GetChStep() * (float)SM_MAX_CH_NUM;

	//   +y
	//    |
	//    @-- Note#0,127 @:Origin(for portB)
	//    |
	//    @-- Note#0,127 @:Origin(for portA)
	//    | |
	//    | | Radius
	//    | |
	// ---0----->+x(time)
	//    |
	//    |
	//    |
	//    *-- PortA
	//    |
	//    *-- PortB
	//    |
	//   -y

	return (m_RingRadius + (portWidth * portIndex));
}

//******************************************************************************
// |[g_ZW擾
//******************************************************************************
float MTNoteDesignRing::GetPortOriginZ(
		unsigned char portNo
	)
{
	//               +y
	//                |
	//           *****@*****      @:Origin(for portB)
	//         **     |     **
	//        *    ***@***    *   @:Origin(for portA)
	//       *   **   |   **   *
	//      *   *     |     *   *
	//      *  *      |      *  *
	// +z<--*--*------0------*--*-->-z
	//      *  *      |      *  *
	//      *   *     |     *   *
	//       *   **   |   **   *
	//        *    *******    *
	//         **     |     **
	//           ***********
	//                |
	//               -y

	return (0.0f);
}

//******************************************************************************
// EWzuړxNg擾
//******************************************************************************
OGLVECTOR3 MTNoteDesignRing::GetWorldMoveVector()
{
	OGLVECTOR3 vector;

	vector.x = 0.0f;
	vector.y = 0.0f;
	vector.z = 0.0f;

	return vector;
}

//******************************************************************************
// m[gW擾
//******************************************************************************
OGLVECTOR3 MTNoteDesignRing::_GetNoteBasePos(
		unsigned int curTickTime,
		unsigned char portNo,
		unsigned char chNo
	)
{
	OGLVECTOR3 vector;

	//tʒu
	vector.x = GetPlayPosX(curTickTime);

	//|[gԍE`lԍŌ_
	vector.y = GetPortOriginY(portNo) + (GetChStep() * chNo);
	vector.z = GetPortOriginZ(portNo);

	return vector;
}

//******************************************************************************
// m[gpx擾
//******************************************************************************
float MTNoteDesignRing::_GetNoteAngle(
		unsigned char noteNo,
		short pitchBendValue,				//ȗFsb`xh
		unsigned char pitchBendSensitivity	//ȗFsb`xhx
	)
{
	float angle = 0.0f;
	float pb = 0.0f;

	//sb`xhɂpx̑
	if (pitchBendValue < 0) {
		pb = m_NoteAngleStep * pitchBendSensitivity * ((float)pitchBendValue / 8192.0f);
	}
	else {
		pb = m_NoteAngleStep * pitchBendSensitivity * ((float)pitchBendValue / 8191.0f);
	}

	//m[gԍŊpx
	angle = ((m_NoteAngleStep * noteNo) + (m_NoteAngleStep / 2.0f) + pb) * LH2RH(1.0f);

	//Cuj^̏ꍇ͔]
	if (m_isLiveMode) {
		angle = angle * (-1.0f);
	}

	return angle;
}

//******************************************************************************
// ݒt@Cǂݍ
//******************************************************************************
int MTNoteDesignRing::_LoadConfFile(
		NSString* pSceneName
	)
{
	int result = 0;
	MTConfFile confFile;

	//ݒt@Cǂݍ
	result = MTNoteDesign::_LoadConfFile(pSceneName);
	if (result != 0) goto EXIT;

	result = confFile.Initialize(pSceneName);
	if (result != 0) goto EXIT;

	//----------------------------------
	//XP[
	//----------------------------------
	result = confFile.SetCurSection(@"Scale");
	if (result != 0) goto EXIT;
	result = confFile.GetFloat(@"RingRadius", &m_RingRadius, 5.0f);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}


