//******************************************************************************
//
// MIDITrail / MTGraphicCfgDlg
//
// グラフィック設定ダイアログ
//
// Copyright (C) 2010-2019 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>
#import "YNBaseLib.h"
#import "OGLRendererInfo.h"


//******************************************************************************
// グラフィック設定ダイアログクラス パラメタ定義
//******************************************************************************
//ノート長拡大率 最小値/最大値
#define MT_QNOTE_LENGTH_MAG_MIN		(0)
#define MT_QNOTE_LENGTH_MAG_MAX		(1000)


//******************************************************************************
// 四分音符長拡大率 テキストフィールドクラス（エディットボックス）
//******************************************************************************
@interface MTQuarterNoteLengthMagTextField : NSTextField {
}

- (BOOL)textShouldEndEditing:(NSText *)textObject;
- (BOOL)isCorrect;
- (BOOL)isCorrectValue:(NSString*)pValue;

@end

//******************************************************************************
// グラフィック設定ダイアログクラス
//******************************************************************************
@interface MTGraphicCfgDlg : NSWindowController {
	
	IBOutlet NSPopUpButton* m_pPopUpBtnAntiAlias;
	IBOutlet NSTextField* m_pEditImageFilePath;
	IBOutlet MTQuarterNoteLengthMagTextField* m_pEditQuarterNoteLengthMag;
	YNUserConf* m_pUserConf;
	OGLRendererInfo m_RendererInfo;
	BOOL m_isChanged;
	
	BOOL m_isEnableAntialias;
	int m_SampleMode;
	int m_SampleNum;
	
	NSString* m_pImageFilePath;
	NSURL* m_pImageFileURL;
	
	int m_QuarterNoteLengthMag;
}

//--------------------------------------
//公開I/F

//生成
- (id)init;

//破棄
- (void)dealloc;

//モーダルウィンドウ表示
- (void)showModalWindow;

//変更確認
- (BOOL)isCahnged;

//--------------------------------------
//イベントハンドラ

//ウィンドウ読み込み完了
- (void)windowDidLoad;

//背景画像ファイル選択ボタン押下
- (IBAction)onBtnImageFileBrowse:(id)sender;

//背景画像ファイルクリアボタン押下
- (IBAction)onBtnImageFileClear:(id)sender;

//OKボタン押下
- (IBAction)onOK:(id)sender;

//Cancelボタン押下
- (IBAction)onCancel:(id)sender;

//クローズボタン押下
- (void)windowWillClose:(NSNotification*)aNotification;

//--------------------------------------
//内部処理

//ダイアログ初期化
- (int)initDlg;

//設定ファイル初期化
- (int)initConfFile;

//設定ファイル読み込み
- (void)loadConfFile;

// アンチエリアスポップアップボタン初期化
- (int)initPopUpButtonAntiAlias;

//背景画像ファイルパス初期化
- (int)initBackgroundImageFilePath;

//四分音符設定初期化
- (int)initQuarterNote;

//設定保存
- (int)saveConfFile;

//アンチエイリアス設定保存
- (int)saveAntiAlias;

//背景画像設定保存
- (int)saveBackgroundImage;

//四分音符設定保存
- (int)saveQuarterNote;

@end


