//******************************************************************************
//
// Simple MIDI Library / SMBarList
//
// ߃XgNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "SMBarList.h"

using namespace YNBaseLib;

namespace SMIDILib {


//******************************************************************************
// RXgN^
//******************************************************************************
SMBarList::SMBarList(void)
 : m_List(sizeof(unsigned long), 100)
{
}

//******************************************************************************
// fXgN^
//******************************************************************************
SMBarList::~SMBarList(void)
{
	Clear();
}

//******************************************************************************
// NA
//******************************************************************************
void SMBarList::Clear(void)
{
	m_List.Clear();
}

//******************************************************************************
// ߏǉ
//******************************************************************************
int SMBarList::AddBar(
		unsigned long tickTime
	)
{
	return m_List.AddItem(&tickTime);
}

//******************************************************************************
// ߏ擾
//******************************************************************************
int SMBarList::GetBar(
		unsigned long index,
		unsigned long* pTickTime
	)
{
	return m_List.GetItem(index, pTickTime);
}

//******************************************************************************
// ߐ擾
//******************************************************************************
unsigned long SMBarList::GetSize()
{
	return m_List.GetSize();
}

//******************************************************************************
// XgRs[
//******************************************************************************
int SMBarList::CopyFrom(
		SMBarList* pSrcList
	)
{
	return m_List.CopyFrom(&(pSrcList->m_List));
}

} // end of namespace

