//******************************************************************************
//
// Simple MIDI Library / SMEvent
//
// CxgNX
//
// Copyright (C) 2010-2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#pragma once

#ifdef SMIDILIB_EXPORTS
#define SMIDILIB_API __declspec(dllexport)
#else
#define SMIDILIB_API __declspec(dllimport)
#endif

namespace SMIDILib {

//******************************************************************************
// p[^`
//******************************************************************************
#define SMEVENT_INTERNAL_DATA_SIZE  (16)


//******************************************************************************
// CxgNX
//******************************************************************************
class SMIDILIB_API SMEvent
{
public:

	//Cxg
	enum EventType {
		EventNone,
		EventMIDI,
		EventSysEx,
		EventSysMsg,
		EventMeta
	};

	//RXgN^^fXgN^
	SMEvent(void);
	virtual ~SMEvent(void);

	//f[^o^
	int SetData(EventType type, unsigned char status, unsigned char meta, unsigned char* pData, unsigned long size);

	//MIDICxgo^
	int SetMIDIData(unsigned char status, unsigned char* pData, unsigned long size);

	//SysExCxgo^
	int SetSysExData(unsigned char status, unsigned char* pData, unsigned long size);

	//SysMsgCxgo^
	int SetSysMsgData(unsigned char status, unsigned char* pData, unsigned long size);

	//^Cxgo^
	int SetMetaData(unsigned char status, unsigned char type, unsigned char* pData, unsigned long size);

	//Cxgʎ擾
	EventType GetType();

	//Xe[^X擾
	unsigned char GetStatus();

	//^ʎ擾
	unsigned char GetMetaType();

	//f[^TCY擾
	unsigned long GetDataSize();

	//f[^|C^擾
	unsigned char* GetDataPtr();

	//NA
	void Clear();

private:

	EventType m_Type;
	unsigned char m_Status;
	unsigned char m_MetaType;
	unsigned long m_DataSize;
	unsigned char m_Data[SMEVENT_INTERNAL_DATA_SIZE];
	unsigned char* m_pExData;

	//ƃRs[RXgN^̋֎~
	void operator=(const SMEvent&);
	SMEvent(const SMEvent&);

};

} // end of namespace

