//******************************************************************************
//
// MIDITrail / MTDashboardLive
//
// Cuj^p_bV{[h`NX
//
// Copyright (C) 2012 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// MIDI IN fCoCX, m[g \B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXColorUtil.h"
#include "MTStaticCaption.h"
#include "MTDynamicCaption.h"


//******************************************************************************
// p[^`
//******************************************************************************
//tHgݒ
//  Windows FtHgTCY40 -> rbg}bvTCYc40sNZ (MS Gothic)
//  Mac OS XFtHgTCY40 -> rbg}bvTCYc50sNZ (Monaco)
#define MTDASHBOARDLIVE_FONTNAME  _T("MS Gothic")
#define MTDASHBOARDLIVE_FONTSIZE  (40)

//JE^LvV
#define MTDASHBOARDLIVE_COUNTER_CHARS  "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:/%[] "

//JE^LvVTCY
//   1234567890123456789012345678901  (31)
//  "NOTES:00000000 [MONITERING OFF]"
//  ]T݂40ɂĂ
#define MTDASHBOARDLIVE_COUNTER_SIZE  (40)

//gTCYisNZj
#define MTDASHBOARDLIVE_FRAMESIZE  (5.0f)

//ftHg\g嗦
#define MTDASHBOARDLIVE_DEFAULT_MAGRATE  (0.45f)  //Windowsłł0.5

//******************************************************************************
// Cuj^p_bV{[h`NX
//******************************************************************************
class MTDashboardLive
{
public:
	
	//RXgN^^fXgN^
	MTDashboardLive(void);
	virtual ~MTDashboardLive(void);
	
	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, HWND hWnd);
	
	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector);
	
	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);
	
	//
	void Release();
	
	//j^ԓo^
	void SetMonitoringStatus(bool isMonitoring);
	
	//m[gONo^
	void SetNoteOn();
	
	//Zbg
	void Reset();
	
	//\ݒ
	void SetEnable(bool isEnable);
	
	//MIDI IN foCXo^
	int SetMIDIINDeviceName(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pName);
	
private:
	
	HWND m_hWnd;

	MTStaticCaption m_Title;
	
	MTDynamicCaption m_Counter;
	float m_PosCounterX;
	float m_PosCounterY;
	float m_CounterMag;
	
	bool m_isMonitoring;
	unsigned long m_NoteCount;
	
	D3DXCOLOR m_CaptionColor;
	
	//\
	bool m_isEnable;
	
	int _GetCounterPos(float* pX, float* pY);
	int _GetCounterStr(TCHAR* pStr, unsigned long bufSize);
	int _LoadConfFile(const TCHAR* pSceneName);
	
};


