//******************************************************************************
//
// MIDITrail / MTSettingBGIMGViewCtrl
//
// 背景画像選択ビュークラス
//
// Copyright (C) 2017-2018 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <UIKit/UIKit.h>
#import "YNBaseLib.h"
#import "MTFileEditViewCtrl.h"


//******************************************************************************
// 背景画像選択ビュー制御クラス
//******************************************************************************
@interface MTSettingBGIMGViewCtrl : UIViewController {
	
	//テーブルビュー
	IBOutlet UITableView* m_pTableView;
	
	//ファイル名一覧
	NSMutableArray* m_pFileArray;
	
	//選択ファイルインデックス
	NSInteger m_SelectedFileIndex;
	
	//選択画像ファイル名
	NSString* m_pImageFileName;
	
	//ユーザ設定
	YNUserConf* m_pUserConf;
	
	//ファイル編集ビュー
	MTFileEditViewCtrl* m_pFileEditViewCtrl;
}

//生成
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil;

//ビュー登録完了
- (void)viewDidLoad;

//ビュー解除完了
//  iOS6で廃止
//- (void)viewDidUnload;

//インターフェース自動回転確認
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

//インターフェース自動回転確認（iOS6以降）
- (BOOL)shouldAutorotate;
- (NSUInteger)supportedInterfaceOrientations;

//ビュー表示
- (void)viewWillAppear:(BOOL)animated;

//ビュー非表示
- (void)viewWillDisappear:(BOOL)animated;

//セクション数
-(NSInteger)numberOfSectionsInTableView:(UITableView*)tableView;

//セクションヘッダ
- (NSString*)tableView:(UITableView*)tableView titleForHeaderInSection:(NSInteger)section;

//セクションごとの項目数
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section;

//項目表示内容
- (UITableViewCell*)tableView:(UITableView*)tableView cellForRowAtIndexPath:(NSIndexPath*)indexPath;

//テーブルセル選択イベント
- (void)tableView:(UITableView*)tableView didSelectRowAtIndexPath:(NSIndexPath*)indexPath;

//選択行ファイルパス取得
- (NSString*)selectedFilePath;

//編集開始終了通知
- (void)setEditing:(BOOL)editing animated:(BOOL)animated;

//行単位削除可否判定
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath;

//行削除イベント
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath;

//ファイル名更新イベント
- (void)onUpdateFileName:(NSNotification*)pNotification;


@end

