//******************************************************************************
//
// MIDITrail / MIDITrailAppDelegate
//
// MIDITrail アプリケーションデリゲート
//
// Copyright (C) 2012-2014 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "MIDITrailAppDelegate.h"


@implementation MIDITrailAppDelegate

//******************************************************************************
// アプリケーション起動処理終了
//******************************************************************************
- (BOOL)application:(UIApplication*)application didFinishLaunchingWithOptions:(NSDictionary*)launchOptions
{
	int result = 0;
	
	NSLog(@"MIDITrailAppDelegate::didFinishLaunching");	
	
	//アプリケーション生成
	m_pApp = [[MIDITrailApp alloc] init];
	
	//アプリケーション初期化
	result = [m_pApp initialize:launchOptions];
	if (result != 0) goto EXIT;
	
	//アプリケーション実行
	result = [m_pApp run];
	if (result != 0) goto EXIT;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return YES;
}

//******************************************************************************
// 非アクティブ状態遷移（電話着信など）
//******************************************************************************
- (void)applicationWillResignActive:(UIApplication*)application
{
	// Xcode自動生成コメント
	// Sent when the application is about to move from active to inactive state.
	// This can occur for certain types of temporary interruptions (such as an 
	// incoming phone call or SMS message) or when the user quits the application 
	// and it begins the transition to the background state.
	// Use this method to pause ongoing tasks, disable timers, and throttle down 
	// OpenGL ES frame rates. Games should use this method to pause the game.
	
	NSLog(@"MIDITrailAppDelegate::applicationWillResignActive");
	
	//非アクティブ状態遷移
	[m_pApp onApplicationWillResignActive];
	
	return;
}

//******************************************************************************
// バックグラウンド状態遷移
//******************************************************************************
- (void)applicationDidEnterBackground:(UIApplication*)application
{
	// Xcode自動生成コメント
	// Use this method to release shared resources, save user data, invalidate 
	// timers, and store enough application state information to restore your 
	// application to its current state in case it is terminated later. 
	// If your application supports background execution, this method is called 
	// instead of applicationWillTerminate: when the user quits.
	
	NSLog(@"MIDITrailAppDelegate::applicationDidEnterBackground");
	
	//バックグラウンド状態遷移
	[m_pApp onApplicationDidEnterBackground];
	
	return;
}

//******************************************************************************
// フォアグラウンド状態遷移：バックグラウンド状態→非アクティブ状態
//******************************************************************************
- (void)applicationWillEnterForeground:(UIApplication*)application
{
	// Xcode自動生成コメント
	// Called as part of the transition from the background to the inactive state; 
	// here you can undo many of the changes made on entering the background.

	NSLog(@"MIDITrailAppDelegate::applicationWillEnterForeground");
	
	return;
}

//******************************************************************************
// アクティブ状態遷移
//******************************************************************************
- (void)applicationDidBecomeActive:(UIApplication*)application
{
	// Xcode自動生成コメント
	// Restart any tasks that were paused (or not yet started) while the 
	// application was inactive. If the application was previously in the 
	// background, optionally refresh the user interface.

	NSLog(@"MIDITrailAppDelegate::applicationDidBecomeActive");
	
	return;
}

//******************************************************************************
// アプリケーション終了
//******************************************************************************
- (void)applicationWillTerminate:(UIApplication*)application
{
	// Xcode自動生成コメント
	// Called when the application is about to terminate. Save data if 
	// appropriate. See also applicationDidEnterBackground:.
	
	int result = 0;
	
	NSLog(@"MIDITrailAppDelegate::applicationWillTerminate");
	
	//アプリケーション停止
	result = [m_pApp terminate];
	if (result != 0) goto EXIT;
	
	[m_pApp release];
	m_pApp = nil;
	
EXIT:;
	if (result != 0) YN_SHOW_ERR();
	return;
}

//******************************************************************************
// 破棄
//******************************************************************************
- (void)dealloc
{
	NSLog(@"MIDITrailAppDelegate::dealloc");
	
	[super dealloc];
	
	return;
}


@end

