//******************************************************************************
//
// MIDITrail / MTFileOpenPanel
//
// ファイル選択パネルクラス
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import <Cocoa/Cocoa.h>
#import "MTStringEncodingList.h"


//******************************************************************************
// ファイル選択パネルクラス
//******************************************************************************
class MTFileOpenPanel
{
public:
	
	//コンストラクタ／デストラクタ
	MTFileOpenPanel(void);
	virtual ~MTFileOpenPanel(void);
	
	//初期化
	int Initialize();
	
	//エンコーディング選択
	int SetSelectedEncodingName(const NSString* pEncodingName);
	
	//ファイル選択パネル表示
	NSInteger showModalWindow();
	
	//選択ファイルパス取得
	const NSString* GetSelectedFilePath();
	
	//選択エンコーディング情報取得
	const NSString* GetSelectedEncodingName();
	unsigned long GetSelectedEncodingId();
	
	//デフォルトエンコーディング情報取得
	const NSString* GetDefaultEncodingName();
	unsigned long GetDefaultEncodingId();
	
private:
	
	//ファイル選択パネル
	NSOpenPanel* m_pPanel;
	
	//アクセサリビュー
	NSView* m_pAccessoryView;
	
	//ラベル
	NSTextField* m_pLabel;
	
	//エンコーディング選択ポップアップボタン
	NSPopUpButton* m_pEncodingPopUp;
	
	//エンコーディングリスト
	MTStringEncodingList m_EncodingList;
	
	//アクセサリビュー生成
	int _CreateAccessoryView();
	
};


