//******************************************************************************
//
// MIDITrail / MIDITrailApp
//
// MIDITrail アプリケーションクラス
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "YNBaseLib.h"
#import "SMIDILib.h"
#import "OGLUtil.h"
#import "DIKeyCtrl.h"
#import "MTScene.h"
#import "MTWindowSizeCfgDlg.h"
#import "MTMIDIOUTCfgDlg.h"
#import "MTGraphicCfgDlg.h"
#import "MTHowToViewDlg.h"
#import "MTAboutDlg.h"
#import "MTStatusDlg.h"
#import "MTCmdLineParser.h"
#import "MTMainWindowCtrl.h"
#import "MTMainView.h"
#import "MTMenuCtrl.h"
#import "MTFileOpenPanel.h"


//******************************************************************************
// パラメータ定義
//******************************************************************************
//演奏状態数
#define MT_PLAYSTATUS_NUM  (4)

//******************************************************************************
// MIDITrail アプリケーションクラス
//******************************************************************************
class MIDITrailApp
{
public:
	
	//シーン種別
	enum SceneType {
		Title,			//タイトル
		PianoRoll3D,	//ピアノロール3D
		PianoRoll2D,	//ピアノロール2D
		PianoRollRain	//ピアノロールレイン
	};
	
public:
	
	//コンストラクタ／デストラクタ
	MIDITrailApp(void);
	virtual ~MIDITrailApp(void);
	
	//初期化
	int Initialize(MTMenuCtrl* pMenuCtrl);
	
	//実行
	int Run();
	
	//停止
	int Terminate();
	
	//アプリケーションアクティブ状態設定
	void OnAppActive();
	void OnAppInactive();
	
	//メニューイベント処理
	int OnMenuAbout();
	int OnMenuFileOpen();
	int OnMenuPlay();
	int OnMenuStop();
	int OnMenuRepeat();
	int OnMenuResetViewpoint();
	int OnMenuSaveViewpoint();
	int OnMenuEnableEffect(MTScene::EffectType type);
	int OnMenuWindowSize();
	int OnMenuOptionMIDIOUT();
	int OnMenuOptionGraphic();
	int OnMenuHowToView();
	int OnMenuManual();
	int OnMenuSelectSceneType(SceneType type);
	
	//演奏状態変更通知
	int OnChangePlayStatusPause();
	int OnChangePlayStatusStop();
	
	//ファイルドロップイベント
	int OnDropFile(NSString* pPath);
	
	//タイマー呼び出し
	unsigned long GetTimerInterval();
	int OnTimer();
	
private:
	
	//----------------------------------------------------------------
	//パラメータ定義
	//----------------------------------------------------------------
	//演奏状態
	enum PlayStatus {
		NoData,			//データなし
		Stop,			//停止状態
		Play,			//再生中
		Pause			//一時停止
	};
	
	//シーケンサメッセージ
	typedef struct {
		unsigned long wParam;
		unsigned long lParam;
	} MTSequencerMsg;
	
	//最新シーケンサメッセージ
	typedef struct {
		bool isRecvPlayTime;
		bool isRecvTempo;
		bool isRecvBar;
		bool isRecvBeat;
		MTSequencerMsg playTime;
		MTSequencerMsg tempo;
		MTSequencerMsg bar;
		MTSequencerMsg beat;
	} MTSequencerLastMsg;
	
private:
	
	//----------------------------------------------------------------
	//メンバ定義
	//----------------------------------------------------------------
	//コマンドラインパーサ
	MTCmdLineParser m_CmdLineParser;
	
	//メインメニュー制御
	MTMenuCtrl* m_pMenuCtrl;
	
	//ウィンドウ系
	MTMainWindowCtrl* m_pMainWindowCtrl;
	MTMainView* m_pMainView;
	MTFileOpenPanel m_FileOpenPanel;
	
	//レンダリング系
	MTScene* m_pScene;
	OGLRedererParam m_RendererParam;
	
	//MIDI制御系
	SMSeqData m_SeqData;
	SMSequencer m_Sequencer;
	SMMsgQueue m_MsgQueue;
	
	//演奏状態
	PlayStatus m_PlayStatus;
	bool m_isRepeat;
	bool m_isRewind;
	MTSequencerLastMsg m_SequencerLastMsg;
	
	//表示効果
	bool m_isEnablePianoKeyboard;
	bool m_isEnableRipple;
	bool m_isEnablePitchBend;
	
	//シーン種別
	SceneType m_SceneType;
	SceneType m_SelectedSceneType;
	
	//設定ファイル
	YNUserConf* m_pUserConf;
	
	//アプリケーションアクティブ状態
	bool m_isAppActive;
	
	//キー入力制御
	DIKeyCtrl m_DIKeyCtrl;
	
	//Aboutダイアログ
	MTAboutDlg* m_pAboutDlg;
	
	//----------------------------------------------------------------
	//メソッド定義
	//----------------------------------------------------------------
	//ウィンドウ制御
	int _CreateWindow();
	int _SetWindowSize();
	
	//初期化処理
	int _InitConfFile();
	int _InitFileOpenPanel();
	
	int _LoadMIDIFile(const NSString* pFilePath);
	int _SetPortDev(SMSequencer* pSequencer);
	int _ChangeWindowSize();
	int _ChangePlayStatus(PlayStatus status);
	int _ChangeMenuStyle();
	int _CreateScene(SceneType type, SMSeqData* pSeqData);
	int _LoadSceneType();
	int _SaveSceneType();
	int _LoadViewpoint();
	int _SaveViewpoint();
	int _LoadGraphicConf();
	int _DispHowToView();
	int _UpdateMenuCheckmark();
	int _UpdateEffect();
	int _ParseCmdLine();
	
};


