/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.logging;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private final StringBuffer stringBuffer = new StringBuffer(2048);

    @Override
    public synchronized String format(LogRecord lr) {
        StackTraceElement[] stack;
        Throwable err = lr.getThrown();
        StringBuffer sb = this.stringBuffer;
        sb.delete(0, this.stringBuffer.length());
        String nl = System.getProperty("line.separator", "\n");
        if (err != null) {
            sb.append("#################### EXCEPTION ####################").append(nl);
        }
        sb.append(String.format("[%s] <%s#%s>: %s%s", lr.getLevel(), lr.getSourceClassName(), lr.getSourceMethodName(), lr.getMessage(), nl));
        if (err != null && (stack = err.getStackTrace()) != null) {
            String indent1 = "    ";
            int len = stack.length;
            sb.append(err.getClass().getName()).append(" : ").append(err.getMessage()).append(nl);
            for (int i = 0; i < len; ++i) {
                sb.append(indent1);
                sb.append(stack[i].toString()).append(nl);
            }
        }
        return sb.toString();
    }
}

