/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.context;

import java.util.Hashtable;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.xmlmodule.deviceinfo.InstType;
import org.rz.midiplayer.xmlmodule.deviceinfo.Instrument;
import org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentMap;

public class InstrumentList
implements Loggable {
    public static final Instrument nullInstrument;
    private final Hashtable<String, Hashtable<HashKey, Instrument>> meloInstrumentTable = new Hashtable();
    private final Hashtable<String, Hashtable<HashKey, Instrument>> drumInstrumentTable = new Hashtable();
    private static final HashKey hashKey;

    InstrumentList() {
    }

    public void clear() {
        this.meloInstrumentTable.clear();
        this.drumInstrumentTable.clear();
    }

    void add(String mode, InstrumentMap map) {
        switch (map.getType()) {
            case MELO: {
                this.meloInstrumentTable.put(mode, this.generateMap(map, 8192));
                break;
            }
            case DRUM: {
                this.drumInstrumentTable.put(mode, this.generateMap(map, 1024));
            }
        }
    }

    private Hashtable<HashKey, Instrument> generateMap(InstrumentMap map, int initialCapacity) {
        Hashtable<HashKey, Instrument> ret = new Hashtable<HashKey, Instrument>(initialCapacity);
        for (Instrument i : map.getInstrument()) {
            HashKey key = new HashKey();
            key.pc = i.getPc();
            key.msb = i.getMsb();
            key.lsb = i.getLsb();
            ret.put(key, i);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument search(String mode, InstType type, int pc, int msb, int lsb) {
        Instrument ret = null;
        HashKey hashKey = InstrumentList.hashKey;
        synchronized (hashKey) {
            InstrumentList.hashKey.pc = pc;
            InstrumentList.hashKey.msb = msb;
            InstrumentList.hashKey.lsb = lsb;
            Hashtable<HashKey, Instrument> table = null;
            switch (type) {
                case MELO: {
                    table = this.meloInstrumentTable.get(mode);
                    break;
                }
                case DRUM: {
                    table = this.drumInstrumentTable.get(mode);
                }
            }
            if (table == null) {
                return nullInstrument;
            }
            ret = (Instrument)table.get(InstrumentList.hashKey);
        }
        if (ret == null) {
            return nullInstrument;
        }
        return ret;
    }

    static {
        hashKey = new HashKey();
        nullInstrument = new Instrument();
        nullInstrument.setLsb(0);
        nullInstrument.setMsb(0);
        nullInstrument.setPc(0);
        nullInstrument.setName("--------");
        nullInstrument.setMapName("--------");
    }

    private static class HashKey {
        int pc;
        int msb;
        int lsb;

        private HashKey() {
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HashKey)) {
                return false;
            }
            HashKey src = (HashKey)obj;
            return this.pc == src.pc && this.msb == src.msb && this.lsb == src.lsb;
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + this.pc;
            hash = 89 * hash + this.msb;
            hash = 89 * hash + this.lsb;
            return hash;
        }

        public String toString() {
            return "pc=" + this.pc + "," + "msb=" + this.msb + "," + "lsb=" + this.lsb;
        }
    }
}

