/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer.pianoroll3d;

import java.util.LinkedList;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayerplugin.renderer.pianoroll3d.NoteObject;

class Process
implements Runnable,
Loggable {
    private final LinkedList<NoteObject> masterObjList;
    private final LinkedList<NoteObject> activeObjList;
    private final LinkedList<NoteObject> workObjList = new LinkedList();
    private volatile boolean threadAlive;
    private Thread thread;

    Process(LinkedList<NoteObject> mas, LinkedList<NoteObject> act) {
        this.masterObjList = mas;
        this.activeObjList = act;
    }

    public void start() {
        this.stop();
        this.thread = new Thread(this);
        this.thread.start();
        logger.info("started processing thread...");
    }

    public void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.threadAlive = false;
                this.thread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.thread = null;
            logger.info("stopped processing thread...");
        }
    }

    @Override
    public void run() {
        long period = 16666666L;
        long sleepDiffTime = 0L;
        boolean except = false;
        long before = System.nanoTime();
        this.threadAlive = true;
        while (this.threadAlive) {
            try {
                this.update();
            }
            catch (Throwable e) {
                except = true;
                break;
            }
            long after = System.nanoTime();
            long diffTime = after - before;
            long sleepTime = period - diffTime - sleepDiffTime;
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime / 1000000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                sleepDiffTime = System.nanoTime() - after - sleepTime;
            } else {
                sleepDiffTime = 0L;
            }
            before = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        LinkedList<NoteObject> linkedList = this.masterObjList;
        synchronized (linkedList) {
            LinkedList<NoteObject> linkedList2 = this.activeObjList;
            synchronized (linkedList2) {
                int i = 0;
                while (i < this.activeObjList.size()) {
                    NoteObject n = this.activeObjList.get(i);
                    if (!n.visible) {
                        this.activeObjList.remove(i);
                        this.masterObjList.addLast(n);
                        continue;
                    }
                    n.update();
                    ++i;
                }
            }
        }
    }
}

