/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.context.InstrumentList;
import org.rz.midiplayer.context.MidiChannel;
import org.rz.midiplayer.context.MidiChannelEventListener;
import org.rz.midiplayer.context.MidiEventHandler;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.xmlmodule.deviceinfo.InstType;
import org.rz.midiplayer.xmlmodule.deviceinfo.Instrument;
import org.rz.midiplayer.xmlmodule.midispec.DrumPartPc;
import org.rz.midiplayer.xmlmodule.midispec.DrumPartSysExec;
import org.rz.midiplayer.xmlmodule.midispec.MeloPartPc;
import org.rz.midiplayer.xmlmodule.midispec.MeloPartSysExec;
import org.rz.midiplayer.xmlmodule.midispec.Spec;

public class DefaultMidiEventHandler
implements Loggable,
MidiEventHandler {
    protected final Context context;
    protected final MidiChannel[] midiChannels = new MidiChannel[16];
    protected final ArrayList<MidiChannelEventListener> midiChannelEventListeners = new ArrayList(32);
    private String currentMidiSpec;
    private int pcMsb;
    private int pcLsb;

    public DefaultMidiEventHandler(Context ctx) {
        this.context = ctx;
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i] = new MidiChannel();
        }
        this.setCurrentMidiSpec(ctx.getDevice().getDeviceInfo().getDefaultMode());
    }

    public String getCurrentMidiSpec() {
        return this.currentMidiSpec;
    }

    public synchronized void setCurrentMidiSpec(String s) {
        if (s != null) {
            this.currentMidiSpec = s;
            this.reset();
        } else {
            logger.warning("********* s is null");
        }
    }

    public synchronized void reset() {
        Spec spec = this.context.getMidiSpecTable().get(this.currentMidiSpec);
        Instrument[] inst = this.getDefaultInstrumentList();
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i].reset();
            this.midiChannels[i].setInstrument(inst[i]);
        }
        int value = spec.getDrumpart().getDefault();
        if (value >= 0) {
            this.midiChannels[value].setDrumMode(true);
        }
        this.pcMsb = 0;
        this.pcLsb = 0;
    }

    public MidiChannel getMidiChannel(int ch) {
        return this.midiChannels[ch];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMidiChannelEventListener(MidiChannelEventListener e) {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            if (e != null && !this.midiChannelEventListeners.contains(e)) {
                this.midiChannelEventListeners.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMidiChannelEventListeners() {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            this.midiChannelEventListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMidiChannelEventListener(MidiChannelEventListener e) {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            if (e != null) {
                this.midiChannelEventListeners.remove(e);
            }
        }
    }

    public synchronized Instrument[] getDefaultInstrumentList() {
        Instrument[] ret = new Instrument[16];
        Spec spec = this.context.getMidiSpecTable().get(this.currentMidiSpec);
        InstrumentList instList = this.context.getDevice().getInstrumentList();
        int defaultMeloPC = spec.getMelopart().getDefaultpc();
        int defaultMeloMSB = spec.getMelopart().getDefaultmsb();
        int defaultMeloLSB = spec.getMelopart().getDefaultlsb();
        int defaultDrumPC = spec.getDrumpart().getDefaultpc();
        int defaultDrumMSB = spec.getDrumpart().getDefaultmsb();
        int defaultDrumLSB = spec.getDrumpart().getDefaultlsb();
        int defaultDrumCH = spec.getDrumpart().getDefault();
        for (int i = 0; i < 16; ++i) {
            ret[i] = i == defaultDrumCH ? instList.search(this.currentMidiSpec, InstType.DRUM, defaultDrumPC, defaultDrumMSB, defaultDrumLSB) : instList.search(this.currentMidiSpec, InstType.MELO, defaultMeloPC, defaultMeloMSB, defaultMeloLSB);
        }
        return ret;
    }

    @Override
    public boolean handleMetaEvent(int type, byte[] data, int length) {
        return false;
    }

    @Override
    public final boolean handleMidiEvent(int ch, int status, byte[] data, int length) {
        MidiChannel channel = this.midiChannels[ch];
        switch (status & 0xFFFFFFF0) {
            case 128: {
                byte data1 = data[1];
                channel.getNoteInfo(data1).noteOff();
                this.dispatchNoteOff(ch, data[1]);
                return true;
            }
            case 144: {
                byte data1 = data[1];
                byte data2 = data[2];
                if (data2 == 0) {
                    channel.getNoteInfo(data1).noteOff();
                    this.dispatchNoteOff(ch, data1);
                } else {
                    channel.getNoteInfo(data1).noteOn(data2);
                    this.dispatchNoteOn(ch, data1, data2);
                }
                return true;
            }
            case 176: {
                byte cc = data[1];
                int v = data[2];
                if (cc == 0) {
                    this.pcMsb = v;
                } else if (cc == 32) {
                    this.pcLsb = v;
                }
                channel.setCcValue(cc, v);
                this.dispatchCcValue(ch, cc, v);
                return true;
            }
            case 192: {
                this.programChangeImpl(ch, data[1], this.pcMsb, this.pcLsb);
                return true;
            }
            case 224: {
                int data1 = data[1] & 0x7F;
                int data2 = data[2] & 0x7F;
                int bend = data2 << 7 | data1;
                channel.setPitchBend(ch);
                this.dispatchPitchbendValue(ch, bend);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleSysExEvent(byte[] data, int length) {
        Object sp = this.context.getMidiSpecArray();
        List<org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentList> instList = this.context.getDevice().getDeviceInfo().getInstruments();
        Iterator<Spec> i$ = ((ArrayList)sp).iterator();
        while (i$.hasNext()) {
            Spec s = i$.next();
            if (!Arrays.equals(s.getReset().getSysexec(), data)) continue;
            for (org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentList inst : instList) {
                if (!inst.getMode().equals(s.getName())) continue;
                this.setCurrentMidiSpec(s.getName());
                this.reset();
                Instrument[] defaultInst = this.getDefaultInstrumentList();
                for (int i = 0; i < 16; ++i) {
                    this.midiChannels[i].setInstrument(defaultInst[i]);
                    this.dispatchProgramChange(i, defaultInst[i]);
                }
                logger.info("********** RESET EXCLUSIVE MESSAGE : " + s.getName());
                return true;
            }
        }
        sp = this.context.getMidiSpecTable().get(this.getCurrentMidiSpec());
        List<DrumPartSysExec> dr = ((Spec)sp).getDrumpart().getDrumpartsysexec();
        InstrumentList instList2 = this.context.getDevice().getInstrumentList();
        for (DrumPartSysExec d : dr) {
            if (!Arrays.equals(d.getSysexec(), data)) continue;
            short ch = d.getChannel();
            Instrument now = this.midiChannels[ch].getInstrument();
            Instrument newInst = instList2.search(this.currentMidiSpec, InstType.DRUM, now.getPc(), now.getMsb(), now.getLsb());
            this.midiChannels[ch].setDrumMode(true);
            this.midiChannels[ch].setInstrument(newInst);
            this.dispatchProgramChange(ch, newInst);
            logger.info("(Maybe) GS : SysEx [USE FOR RHYTHM PART (ON)] ch=" + ch);
            return true;
        }
        sp = this.context.getMidiSpecTable().get(this.getCurrentMidiSpec());
        List<MeloPartSysExec> ml = ((Spec)sp).getMelopart().getMelopartsysexec();
        instList2 = this.context.getDevice().getInstrumentList();
        for (MeloPartSysExec m : ml) {
            if (!Arrays.equals(m.getSysexec(), data)) continue;
            short ch = m.getChannel();
            Instrument now = this.midiChannels[ch].getInstrument();
            Instrument newInst = instList2.search(this.currentMidiSpec, InstType.MELO, now.getPc(), now.getMsb(), now.getLsb());
            this.midiChannels[ch].setDrumMode(false);
            this.midiChannels[ch].setInstrument(newInst);
            this.dispatchProgramChange(ch, newInst);
            logger.info("(Maybe) GS : SysEx [USE FOR RHYTHM PART (OFF)] ch=" + ch);
            return true;
        }
        return false;
    }

    private void programChangeImpl(int ch, int pc, int msb, int lsb) {
        List<MeloPartPc> ml;
        int _lsb;
        int _msb;
        int _ch;
        Spec spec = this.context.getMidiSpecTable().get(this.currentMidiSpec);
        InstrumentList instList = this.context.getDevice().getInstrumentList();
        MidiChannel channel = this.midiChannels[ch];
        List<DrumPartPc> dr = spec.getDrumpart().getDrumpartpc();
        if (!dr.isEmpty()) {
            for (DrumPartPc drumPartPc : dr) {
                _ch = drumPartPc.getCh();
                _msb = drumPartPc.getMsb();
                _lsb = drumPartPc.getLsb();
                if (_ch < 0) {
                    _ch = ch;
                }
                if (_msb < 0) {
                    _msb = msb;
                }
                if (_lsb < 0) {
                    _lsb = lsb;
                }
                if (_ch != ch || _msb != msb || _lsb != lsb) continue;
                logger.info("1: Searching for Drum inst(CC) : ch=" + ch + ", pc=" + pc + ", msb=" + msb + ", lsb=" + lsb);
                Instrument newInst = instList.search(this.currentMidiSpec, InstType.DRUM, pc, msb, lsb);
                channel.setInstrument(newInst);
                channel.setDrumMode(true);
                this.dispatchProgramChange(ch, newInst);
                return;
            }
        }
        if (!(ml = spec.getMelopart().getMelopartpc()).isEmpty()) {
            for (MeloPartPc meloPartPc : ml) {
                _ch = meloPartPc.getCh();
                _msb = meloPartPc.getMsb();
                _lsb = meloPartPc.getLsb();
                if (_ch < 0) {
                    _ch = ch;
                }
                if (_msb < 0) {
                    _msb = msb;
                }
                if (_lsb < 0) {
                    _lsb = lsb;
                }
                if (_ch != ch || _msb != msb || _lsb != lsb) continue;
                logger.info("2: Searching for Melo inst(CC) : ch=" + ch + ", pc=" + pc + "msb=" + msb + ", lsb=" + lsb);
                Instrument newInst = instList.search(this.currentMidiSpec, InstType.MELO, pc, msb, lsb);
                channel.setInstrument(newInst);
                channel.setDrumMode(false);
                this.dispatchProgramChange(ch, newInst);
                return;
            }
        }
        InstType type = channel.isDrumMode() ? InstType.DRUM : InstType.MELO;
        Instrument newInst = instList.search(this.currentMidiSpec, type, pc, msb, lsb);
        channel.setInstrument(newInst);
        this.dispatchProgramChange(ch, newInst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProgramChange(int ch, Instrument i) {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            for (MidiChannelEventListener e : this.midiChannelEventListeners) {
                e.programChange(ch, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchNoteOn(int ch, int noteNo, int vel) {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            for (MidiChannelEventListener e : this.midiChannelEventListeners) {
                e.noteOn(ch, noteNo, vel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchNoteOff(int ch, int noteNo) {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            for (MidiChannelEventListener e : this.midiChannelEventListeners) {
                e.noteOff(ch, noteNo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCcValue(int ch, int ccNo, int value) {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            for (MidiChannelEventListener e : this.midiChannelEventListeners) {
                e.changedCcValue(ch, ccNo, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchPitchbendValue(int ch, int value) {
        ArrayList<MidiChannelEventListener> arrayList = this.midiChannelEventListeners;
        synchronized (arrayList) {
            for (MidiChannelEventListener e : this.midiChannelEventListeners) {
                e.changedPitchbend(ch, value);
            }
        }
    }
}

