/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.context;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.rz.midiplayer.context.InstrumentList;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.xmlmodule.JAXBUtil;
import org.rz.midiplayer.xmlmodule.XSDConstants;
import org.rz.midiplayer.xmlmodule.deviceinfo.DeviceInfo;
import org.rz.midiplayer.xmlmodule.deviceinfo.ImportInfo;
import org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentMap;
import org.xml.sax.SAXException;

public class Device
implements Loggable {
    private final JAXBUtil<DeviceInfo> jaxbUtil = new JAXBUtil<DeviceInfo>(DeviceInfo.class);
    private final String baseDir;
    private DeviceInfo deviceInfo;
    private final InstrumentList instrumentList = new InstrumentList();

    public Device(String baseDir_) {
        this.baseDir = baseDir_;
    }

    synchronized void dispose() {
        this.instrumentList.clear();
        this.deviceInfo = null;
    }

    public InstrumentList getInstrumentList() {
        return this.instrumentList;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    synchronized void load(String deviceFile) throws JAXBException, SAXException {
        this.deviceInfo = this.loadImpl(this.baseDir + File.separator + deviceFile, null);
        this.instrumentList.clear();
        for (org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentList instList : this.deviceInfo.getInstruments()) {
            for (InstrumentMap i : instList.getMap()) {
                this.instrumentList.add(instList.getMode(), i);
            }
            if (logger.getLevel() == Level.OFF) continue;
            int allNum = 0;
            for (InstrumentMap m : instList.getMap()) {
                allNum += m.getInstrument().size();
            }
            logger.info("mode:" + instList.getMode() + ", map=" + instList.getMap().size() + ", size=" + allNum);
        }
    }

    private DeviceInfo loadImpl(String deviceFile, DeviceInfo target) throws JAXBException, SAXException {
        if (target == null) {
            logger.info("loading : " + deviceFile);
            target = (DeviceInfo)this.jaxbUtil.loadFromFile(XSDConstants.DEVICEINFO_XSD_URI, deviceFile).getValue();
        }
        ArrayList<DeviceInfo> extendList = new ArrayList<DeviceInfo>(16);
        List<ImportInfo> impInfoList = target.getImport();
        for (ImportInfo i : impInfoList) {
            DeviceInfo inf = this.loadImpl(this.baseDir + File.separator + i.getFile(), null);
            extendList.add(inf);
        }
        if (extendList.isEmpty()) {
            return target;
        }
        return this.extend(extendList, target);
    }

    private DeviceInfo extend(ArrayList<DeviceInfo> from, DeviceInfo target) {
        for (DeviceInfo inf : from) {
            for (org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentList list : inf.getInstruments()) {
                target.getInstruments().add(list);
            }
        }
        return target;
    }
}

