/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.midi;

import java.util.Vector;
import java.util.logging.Level;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Transmitter;
import org.rz.midiplayer.logging.Loggable;

public class MIDIDeviceManager
implements Loggable {
    private MIDIDeviceManager() {
    }

    public static synchronized Vector<MidiDevice> getDeviceList() {
        Vector<MidiDevice> ret = new Vector<MidiDevice>(32);
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        if (infos != null) {
            for (MidiDevice.Info i : infos) {
                try {
                    ret.add(MidiSystem.getMidiDevice(i));
                }
                catch (MidiUnavailableException e) {
                    logger.log(Level.WARNING, "cannot get a MIDI Device.", e);
                }
            }
        }
        return ret;
    }

    public static synchronized Vector<MidiDevice> getMidiOutDeviceList() {
        Vector<MidiDevice> list = MIDIDeviceManager.getDeviceList();
        Vector<MidiDevice> ret = new Vector<MidiDevice>(16);
        for (MidiDevice d : list) {
            if (d.getMaxReceivers() == 0) continue;
            ret.add(d);
        }
        return ret;
    }

    public static synchronized Vector<MidiDevice> getMidiInDeviceList() {
        Vector<MidiDevice> list = MIDIDeviceManager.getDeviceList();
        Vector<MidiDevice> ret = new Vector<MidiDevice>(16);
        for (MidiDevice d : list) {
            if (d.getMaxTransmitters() == 0) continue;
            ret.add(d);
        }
        return ret;
    }

    public static MidiDevice searchMidiOutDevice(String deviceName) {
        Vector<MidiDevice> list = MIDIDeviceManager.getMidiOutDeviceList();
        for (MidiDevice i : list) {
            if (!i.getDeviceInfo().getName().equals(deviceName)) continue;
            return i;
        }
        return null;
    }

    public static MidiDevice searchMidiInDevice(String deviceName) {
        Vector<MidiDevice> list = MIDIDeviceManager.getMidiInDeviceList();
        for (MidiDevice i : list) {
            if (!i.getDeviceInfo().getName().equals(deviceName)) continue;
            return i;
        }
        return null;
    }

    public static boolean existMidiOutDevice(String deviceName) {
        Vector<MidiDevice> list = MIDIDeviceManager.getMidiOutDeviceList();
        for (MidiDevice i : list) {
            if (!i.getDeviceInfo().getName().equals(deviceName)) continue;
            return true;
        }
        return false;
    }

    public static boolean existMidiInDevice(String deviceName) {
        Vector<MidiDevice> list = MIDIDeviceManager.getMidiInDeviceList();
        for (MidiDevice i : list) {
            if (!i.getDeviceInfo().getName().equals(deviceName)) continue;
            return true;
        }
        return false;
    }

    public static void close(MidiDevice m) {
        try {
            for (Transmitter t : m.getTransmitters()) {
                MIDIDeviceManager.close(t);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            for (Receiver r : m.getReceivers()) {
                MIDIDeviceManager.close(r);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (m.isOpen()) {
                m.close();
                logger.info("Closed MIDI Device: " + m.getDeviceInfo().getName() + "@" + m.hashCode());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(Transmitter t) {
        try {
            t.close();
            logger.info("Closed Transmitter: " + t.getClass().getName() + "@" + t.hashCode());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(Receiver r) {
        try {
            r.close();
            logger.info("Closed Receiver: " + r.getClass().getName() + "@" + r.hashCode());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized void closeAllDevice() {
        Vector<MidiDevice> list = MIDIDeviceManager.getDeviceList();
        for (MidiDevice i : list) {
            if (!i.isOpen()) continue;
            MIDIDeviceManager.close(i);
        }
    }

    public static void stop(Sequencer seq) {
        try {
            if (seq.isRunning()) {
                seq.stop();
                logger.info("Sequencer is stopped. : " + seq.getDeviceInfo().getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

