/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.context.InstrumentList;
import org.rz.midiplayer.context.SimpleHandler;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.midi.MidiEventListener;
import org.rz.midiplayer.xmlmodule.deviceinfo.InstType;
import org.rz.midiplayer.xmlmodule.deviceinfo.Instrument;
import org.rz.midiplayer.xmlmodule.midispec.DrumPartPc;
import org.rz.midiplayer.xmlmodule.midispec.DrumPartSysExec;
import org.rz.midiplayer.xmlmodule.midispec.MeloPartPc;
import org.rz.midiplayer.xmlmodule.midispec.MeloPartSysExec;
import org.rz.midiplayer.xmlmodule.midispec.Spec;

public class DefaultSimpleHandler
implements Loggable,
SimpleHandler,
MidiEventListener {
    protected final Context context;
    private String currentMidiSpec;
    private final int[] drumChennels = new int[16];
    private int maxAssignDrumChannels;
    private int ccMsb;
    private int ccLsb;

    public DefaultSimpleHandler(Context ctx) {
        this.context = ctx;
        this.setCurrentMidiSpec(ctx.getDevice().getDeviceInfo().getDefaultMode());
        this.reset();
    }

    public String getCurrentMidiSpec() {
        return this.currentMidiSpec;
    }

    public synchronized void setCurrentMidiSpec(String s) {
        if (s != null) {
            this.currentMidiSpec = s;
        } else {
            logger.warning("********* s is null");
        }
    }

    @Override
    public synchronized void reset() {
        Arrays.fill(this.drumChennels, -1);
        Spec spec = this.context.getMidiSpecTable().get(this.currentMidiSpec);
        this.maxAssignDrumChannels = spec.getDrumpart().getMaxassign();
        int value = spec.getDrumpart().getDefault();
        if (value >= 0) {
            this.drumChennels[0] = value;
        }
        this.ccMsb = 0;
        this.ccLsb = 0;
    }

    public synchronized Instrument[] getDefaultInstrumentList() {
        Instrument[] ret = new Instrument[16];
        int defaultDrumCH = 10;
        Spec spec = this.context.getMidiSpecTable().get(this.currentMidiSpec);
        InstrumentList instList = this.context.getDevice().getInstrumentList();
        int defaultMeloPC = spec.getMelopart().getDefaultpc();
        int defaultMeloMSB = spec.getMelopart().getDefaultmsb();
        int defaultMeloLSB = spec.getMelopart().getDefaultlsb();
        int defaultDrumPC = spec.getDrumpart().getDefaultpc();
        int defaultDrumMSB = spec.getDrumpart().getDefaultmsb();
        int defaultDrumLSB = spec.getDrumpart().getDefaultlsb();
        if (spec != null) {
            defaultDrumCH = spec.getDrumpart().getDefault();
        }
        for (int i = 0; i < 16; ++i) {
            ret[i] = i == defaultDrumCH ? instList.search(this.currentMidiSpec, InstType.DRUM, defaultDrumPC, defaultDrumMSB, defaultDrumLSB) : instList.search(this.currentMidiSpec, InstType.MELO, defaultMeloPC, defaultMeloMSB, defaultMeloLSB);
        }
        return ret;
    }

    @Override
    public boolean handleMetaEvent(int type, byte[] data, int length) {
        return false;
    }

    @Override
    public final boolean handleMidiEvent(int ch, int status, byte[] data, int length) {
        switch (status & 0xFFFFFFF0) {
            case 128: {
                this.noteOff(ch, data[1]);
                return true;
            }
            case 144: {
                byte data1 = data[1];
                byte data2 = data[2];
                if (data2 == 0) {
                    this.noteOff(ch, data1);
                } else {
                    this.noteOn(ch, data1, data2);
                }
                return true;
            }
            case 176: {
                byte cc = data[1];
                int v = data[2];
                if (cc == 0) {
                    this.ccMsb = v;
                } else if (cc == 32) {
                    this.ccLsb = v;
                }
                this.changedCcValue(ch, cc, v);
                return true;
            }
            case 192: {
                this.programChange(ch, this.getInstrumentOnPc(ch, data[1], this.ccMsb, this.ccLsb));
                return true;
            }
            case 224: {
                int data1 = data[1] & 0x7F;
                int data2 = data[2] & 0x7F;
                this.changedPitchbend(ch, data2 << 7 | data1);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleSysExEvent(byte[] data, int length) {
        Object sp = this.context.getMidiSpecArray();
        List<org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentList> instList = this.context.getDevice().getDeviceInfo().getInstruments();
        Iterator<Object> i$ = ((ArrayList)sp).iterator();
        while (i$.hasNext()) {
            Spec s = i$.next();
            if (!Arrays.equals(s.getReset().getSysexec(), data)) continue;
            for (org.rz.midiplayer.xmlmodule.deviceinfo.InstrumentList inst : instList) {
                if (!inst.getMode().equals(s.getName())) continue;
                this.setCurrentMidiSpec(s.getName());
                this.reset();
                Instrument[] defaultInst = this.getDefaultInstrumentList();
                for (int i = 0; i < 16; ++i) {
                    this.programChange(i, defaultInst[i]);
                }
                logger.info("********** RESET EXCLUSIVE MESSAGE : " + s.getName());
                return true;
            }
        }
        sp = this.context.getMidiSpecTable().get(this.getCurrentMidiSpec());
        List<DrumPartSysExec> dr = ((Spec)sp).getDrumpart().getDrumpartsysexec();
        for (DrumPartSysExec d : dr) {
            if (!Arrays.equals(d.getSysexec(), data)) continue;
            short ch = d.getChannel();
            short target = d.getTarget();
            this.drumChennels[target] = ch;
            logger.info("GS : SysEx [USE FOR RHYTHM PART (ON)] ch=" + ch + " DT=" + target);
        }
        sp = this.context.getMidiSpecTable().get(this.getCurrentMidiSpec());
        List<MeloPartSysExec> ml = ((Spec)sp).getMelopart().getMelopartsysexec();
        for (MeloPartSysExec m : ml) {
            if (!Arrays.equals(m.getSysexec(), data)) continue;
            short ch = m.getChannel();
            for (int i = 0; i < this.maxAssignDrumChannels; ++i) {
                if (this.drumChennels[i] != ch) continue;
                this.drumChennels[i] = -1;
                logger.info("GS : SysEx [USE FOR RHYTHM PART (OFF)] ch=" + ch);
                break;
            }
            return true;
        }
        return false;
    }

    private Instrument getInstrumentOnPc(int ch, int pc, int msb, int lsb) {
        List<MeloPartPc> ml;
        int _lsb;
        int _msb;
        int _ch;
        Spec spec = this.context.getMidiSpecTable().get(this.currentMidiSpec);
        InstrumentList instList = this.context.getDevice().getInstrumentList();
        List<DrumPartPc> dr = spec.getDrumpart().getDrumpartpc();
        if (!dr.isEmpty()) {
            for (DrumPartPc drumPartPc : dr) {
                boolean b = false;
                _ch = drumPartPc.getCh();
                _msb = drumPartPc.getMsb();
                _lsb = drumPartPc.getLsb();
                if (this.maxAssignDrumChannels > 0) {
                    for (int i = 0; i < this.maxAssignDrumChannels; ++i) {
                        if (this.drumChennels[i] != ch) continue;
                        b = true;
                        break;
                    }
                } else {
                    b = true;
                }
                if (b) {
                    if (_ch < 0) {
                        _ch = ch;
                    }
                    if (_msb < 0) {
                        _msb = msb;
                    }
                    if (_lsb < 0) {
                        _lsb = lsb;
                    }
                    if (_ch != ch || _msb != msb || _lsb != lsb) continue;
                    logger.info("1: Searching for Drum inst(CC) : ch=" + ch + ", pc=" + pc + ", msb=" + msb + ", lsb=" + lsb);
                    return instList.search(this.currentMidiSpec, InstType.DRUM, pc, msb, lsb);
                }
                break;
            }
        } else if (this.maxAssignDrumChannels > 0) {
            for (int i = 0; i < this.maxAssignDrumChannels; ++i) {
                if (this.drumChennels[i] != ch) continue;
                logger.info("2: Searching for Drum inst(CC) : ch=" + ch + ", pc=" + pc + "msb=" + msb + ", lsb=" + lsb);
                return instList.search(this.currentMidiSpec, InstType.DRUM, pc, msb, lsb);
            }
        }
        if (!(ml = spec.getMelopart().getMelopartpc()).isEmpty()) {
            for (MeloPartPc meloPartPc : ml) {
                boolean valid = false;
                _ch = meloPartPc.getCh();
                _msb = meloPartPc.getMsb();
                _lsb = meloPartPc.getLsb();
                if (_ch < 0) {
                    _ch = ch;
                }
                if (_msb < 0) {
                    _msb = msb;
                }
                if (_lsb < 0) {
                    _lsb = lsb;
                }
                if (_ch != ch || _msb != msb || _lsb != lsb) continue;
                logger.info("3: Searching for Melo inst(CC) : ch=" + ch + ", pc=" + pc + "msb=" + msb + ", lsb=" + lsb);
                return instList.search(this.currentMidiSpec, InstType.MELO, pc, msb, lsb);
            }
        } else {
            logger.info("4: Searching for Melo inst(CC) : ch=" + ch + ", pc=" + pc + "msb=" + msb + ", lsb=" + lsb);
            return instList.search(this.currentMidiSpec, InstType.MELO, pc, msb, lsb);
        }
        return InstrumentList.nullInstrument;
    }

    @Override
    public void changedCcValue(int ch, int ccNo, int value) {
    }

    @Override
    public void changedMidiSpec(String name) {
    }

    @Override
    public void changedPitchbend(int ch, int value) {
    }

    @Override
    public void noteOff(int ch, int note) {
    }

    @Override
    public void noteOn(int ch, int note, int vel) {
    }

    @Override
    public void programChange(int ch, Instrument inst) {
    }
}

