#define MINERROR (0.000001)

float COS(float x);
float SIN(float x);

float fabs(float a){
	if(a < 0){
		a = -a;
	}
	return a;
}

int main(){
	float *dest;
	float v = 0;
	int i;
	dest = (float*)(4256);
	for(i = 0; i < 4; i++){
		*dest = COS(v);
		dest++;
		v = v + 0.1;
	}
	*dest = SIN(0);
	dest++;
	*dest = SIN(0.1);
	dest++;
	*dest = SIN(0.2);
	dest++;
	*dest = SIN(0.3);
//	for(i = 0; i < 8; i++){
//		*dest = COS(v);
//		dest++;
//		v = v + 0.1;
//	}
//	for(i = 0; i < 8; i++){
//		*dest = SIN(v);
//		dest++;
//		v = v + 0.1;
//	}
}

float COS(float x){
    float t;
    float  y;
    int n;
    
    y = 1.0;
    t = 1.0;
    n = 1;
    while( 1 ){
        t = - t*x*x/((2*n)*(2*n-1));
        if (fabs(t) <= MINERROR) break;
        y = y + t;
        n++;
    }
    return y;
}

float SIN(float x){
    float t;
    int n;
    
    t = x;
    n = 1;
    while( 1 ){
	  t = - t*x*x/((2*n+1)*(2*n));
	  if (fabs(t) <= MINERROR) break;
	  x = x + t;
	  n++;
    }
    return x;
}
