/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.util;

import java.util.ArrayList;
import java.util.Iterator;
import net.wasamon.mics.Channel;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsException;

public class ChannelManager {
    private ArrayList channels;
    private MicsCompositeElement composite;

    public ChannelManager(MicsCompositeElement composite) {
        this.composite = composite;
        this.channels = new ArrayList();
    }

    public void add(String id, int offset) {
        this.channels.add(new Element(this.composite, id, offset));
    }

    public Element[] array() {
        return this.channels.toArray(new Element[this.channels.size()]);
    }

    public Element search(int offset) throws IndexOutOfBoundsException {
        Iterator i = this.channels.iterator();
        Element element = null;
        while (i.hasNext()) {
            Element v = (Element)i.next();
            if (v.offset > offset || element != null && v.offset < element.offset) continue;
            element = v;
        }
        if (element == null) {
            throw new IndexOutOfBoundsException();
        }
        return element;
    }

    public int search(Channel c) {
        Iterator i = this.channels.iterator();
        while (i.hasNext()) {
            Element v = (Element)i.next();
            try {
                if (v.getChannel() != c) continue;
                return v.offset;
            }
            catch (MicsException micsException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String[] getConnectedElements() {
        String[] s = new String[this.channels.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = ((Element)this.channels.get((int)i)).id;
            ++i;
        }
        return s;
    }

    public class Element {
        public String id;
        public int offset;
        public MicsCompositeElement composite;
        private Channel channelInstance;

        public Element(MicsCompositeElement composite, String id, int offset) {
            this.composite = composite;
            this.id = id;
            this.offset = offset;
        }

        public Channel getChannel() throws MicsException {
            if (this.channelInstance == null) {
                this.channelInstance = this.composite.getChannel(this.id);
            }
            return this.channelInstance;
        }
    }
}

