/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.rlu.ConfigDataViewer;
import net.wasamon.mics.processor.rlu.ExternalDataInterface;
import net.wasamon.mics.processor.rlu.LogicUnit;
import net.wasamon.mjlib.print.FormatException;
import net.wasamon.mjlib.print.PrintFormat;
import net.wasamon.mjlib.util.DataUtil;
import org.w3c.dom.Node;

public class ReconfigurableUnit
extends MicsElement
implements ExecutableElement,
ChannelConnectable,
DataBuffer,
MicsViewable {
    LogicUnit[] unit;
    private int size;
    private ExternalDataInterface[] input;
    private String busID;
    private int ruAddr;
    private int contextAddr;
    private RandomAccessMemory context;
    private char busbuffer;
    private Channel busInstance = null;
    private ConfigDataViewer viewer = null;

    private void initialize(int size) {
        this.context = new RandomAccessMemory(4 * size * size);
        this.contextAddr = 0;
        this.unit = new LogicUnit[size * size];
        this.input = new ExternalDataInterface[size];
    }

    private DataBuffer[] getSrcLogicUnitArray(int id) {
        DataBuffer[] connections = new DataBuffer[6];
        if (id / this.size == 0) {
            connections[0] = this.input[id % this.size];
        }
        connections[1] = id % this.size == 0 ? null : this.unit[id - 1];
        connections[2] = id % this.size == 0 ? null : (id / this.size == 0 ? this.input[id % this.size - 1] : this.unit[id - this.size - 1]);
        connections[3] = id / this.size == 0 ? null : this.unit[id - this.size];
        connections[4] = id % this.size == this.size - 1 ? null : (id / this.size == 0 ? this.input[id % this.size + 1] : this.unit[id - this.size + 1]);
        connections[5] = id % this.size == this.size - 1 ? null : this.unit[id + 1];
        return connections;
    }

    private void setSize(String base, Node n) throws NumberFormatException {
        Integer value = this.getAttributeAsInt(n, "size");
        if (value == null) {
            throw new NumberFormatException("size value is illegal");
        }
        this.size = value;
        this.initialize(this.size);
    }

    private void setChannel(String base, Node n) throws MicsException {
        Node n0 = this.getNamedNode(n, "channel");
        if (n0 == null) {
            throw new MicsException("configuration syntax error for " + this.getClass().getName() + ": channel not found.");
        }
        Integer value = this.getAttributeAsInt(n0, "offset");
        if (value == null) {
            throw new MicsException("configuration syntax error for " + this.getClass().getName() + ": channel offset is not defined.");
        }
        String id = this.getAttributeAsString(n0, "id");
        if (id == null) {
            throw new MicsException("configuration syntax error for " + this.getClass().getName() + ": channel id is not defined.");
        }
        this.busID = id;
        this.ruAddr = value;
        int i = 0;
        while (i < this.size) {
            this.input[i] = new ExternalDataInterface(this.bus(), this.ruAddr + i * 4, null);
            ++i;
        }
        i = 0;
        while (i < this.size) {
            this.unit[this.size * (this.size - 1) + i].setChannel(this.bus(), this.ruAddr + this.size * 4 + 4 * i);
            ++i;
        }
    }

    private void setInitialMemoryValue(String base, Node n) throws MicsException {
        Node[] init_var__init_obj = this.getNamedNodeArray(n, "init");
        int i = 0;
        while (i < init_var__init_obj.length) {
            Integer value;
            Node init_var__init_node = init_var__init_obj[i];
            String init_var__init_file = this.getAttributeAsString(init_var__init_node, "file");
            if (init_var__init_file.charAt(0) != '/') {
                init_var__init_file = String.valueOf(base) + "/" + init_var__init_file;
            }
            if ((value = this.getAttributeAsInt(init_var__init_node, "offset")) == null) {
                throw new MicsException("configuration syntax error for " + this.getClass().getName() + ": init offset is not defined.");
            }
            try {
                this.write(value, new BufferedInputStream(new FileInputStream(init_var__init_file)));
            }
            catch (FileNotFoundException e) {
                System.out.println("no such file: " + init_var__init_file);
                System.out.println("[W] no data is written as initialize.");
            }
            ++i;
        }
    }

    public void initialize(String base, Node n) throws MicsException {
        try {
            this.setSize(base, n);
            int i = 0;
            while (i < this.size * this.size) {
                this.unit[i] = new LogicUnit();
                ++i;
            }
            this.setChannel(base, n);
            i = 0;
            while (i < this.size * this.size) {
                this.unit[i].initialize(this.getSrcLogicUnitArray(i));
                ++i;
            }
            this.setInitialMemoryValue(base, n);
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error for " + this.getClass().getName());
        }
    }

    public int size() {
        return this.unit.length;
    }

    public MicsDataPacket read(MicsDataPacket d) {
        return this.context.read(d);
    }

    public void write(MicsDataPacket d) {
        this.context.write(d);
        this.unit[((RandomAccessMemoryDataPacket)d).addr / 4].setLogicUnit(d);
    }

    public void write(int addr, InputStream reader) throws DataBufferException {
        this.context.write(addr, reader);
        this.setLogicUnit();
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
        this.context.dump(offset, len, writer);
    }

    public String toString(int addr, int length) {
        return this.context.toString(addr, length);
    }

    public void reset() {
        int i = 0;
        while (i < this.unit.length) {
            this.unit[i].reset();
            ++i;
        }
    }

    public void writeback(MicsDataPacket value) {
        this.busbuffer = DataUtil.toChar(((RandomAccessMemoryDataPacket)value).data, 0, 2);
    }

    public int getChannelOffset(Channel c) {
        return this.ruAddr;
    }

    private Channel bus() throws MicsException {
        if (this.busInstance == null) {
            this.busInstance = this.composite.getChannel(this.busID);
        }
        return this.busInstance;
    }

    public char getInputData(int addr) throws MicsException {
        this.bus().readRequest(this, RandomAccessMemoryDataPacket.readPacket(addr, 1, 16));
        return this.busbuffer;
    }

    public ExecInfo exec_first() throws MicsException {
        ExecInfo info = new ExecInfo();
        int i = 0;
        while (i < this.unit.length) {
            this.unit[i].exec_first();
            ++i;
        }
        info.setTerminatableFlag(true);
        return info;
    }

    public ExecInfo exec_second() throws MicsException {
        int i = 0;
        while (i < this.unit.length) {
            this.unit[i].exec_second();
            ++i;
        }
        return null;
    }

    private char readData(DataBuffer buf, int reg) throws MicsException {
        MicsDataPacket p = buf.read(RandomAccessMemoryDataPacket.readPacket(reg * 2, 2, 8));
        return DataUtil.toChar(((RandomAccessMemoryDataPacket)p).data, 0, 2);
    }

    public String toString() {
        String str = "";
        try {
            str = String.valueOf(str) + "==\n";
            int j = 0;
            while (j < this.size) {
                str = String.valueOf(str) + PrintFormat.print("%04x", this.readData(this.input[j], 0));
                str = String.valueOf(str) + ":";
                str = String.valueOf(str) + PrintFormat.print("%04x", this.readData(this.input[j], 1));
                str = String.valueOf(str) + ":";
                str = String.valueOf(str) + PrintFormat.print("%04x", this.readData(this.input[j], 2));
                str = String.valueOf(str) + " ";
                ++j;
            }
            str = String.valueOf(str) + "\n";
            str = String.valueOf(str) + "--\n";
            int i = 0;
            while (i < this.size) {
                int j2 = 0;
                while (j2 < this.size) {
                    str = String.valueOf(str) + PrintFormat.print("%04x", this.readData(this.unit[i * this.size + j2], 0));
                    str = String.valueOf(str) + ":";
                    str = String.valueOf(str) + PrintFormat.print("%04x", this.readData(this.unit[i * this.size + j2], 1));
                    str = String.valueOf(str) + ":";
                    str = String.valueOf(str) + PrintFormat.print("%04x", this.readData(this.unit[i * this.size + j2], 2));
                    str = String.valueOf(str) + " ";
                    ++j2;
                }
                str = String.valueOf(str) + "\n";
                ++i;
            }
        }
        catch (FormatException e) {
            str = String.valueOf(str) + "catch: " + e.getMessage();
        }
        catch (MicsException e) {
            str = String.valueOf(str) + "catch: " + e.getMessage();
        }
        return str;
    }

    private void setLogicUnit() {
        int i = 0;
        while (i < this.size * this.size) {
            this.unit[i].setLogicUnit(this.context.read(RandomAccessMemoryDataPacket.readPacket(this.contextAddr + i * 4, 4, 8)));
            ++i;
        }
    }

    public String[] getConnectedElements() {
        return new String[]{this.busID};
    }

    public String getInfo() {
        String s = "";
        s = String.valueOf(s) + "ReconfigurableUnit\n";
        s = String.valueOf(s) + "  CLASS: " + this.getClass().getName() + "\n";
        s = String.valueOf(s) + "  ID: " + this.id() + "\n";
        s = String.valueOf(s) + "  Local Memory ID: " + this.context.id() + ",";
        s = String.valueOf(s) + " offset = " + this.contextAddr + "\n";
        s = String.valueOf(s) + "  Channel ID: ";
        try {
            s = String.valueOf(s) + ((MicsElement)((Object)this.bus())).id() + ",";
        }
        catch (MicsException e) {
            s = String.valueOf(s) + "unconnected,";
        }
        s = String.valueOf(s) + " input offset = " + this.ruAddr + ",";
        s = String.valueOf(s) + " output offset = " + (this.ruAddr + this.size * 4);
        return s;
    }

    public void show() {
        if (this.viewer == null) {
            this.viewer = new ConfigDataViewer();
        }
        this.viewer.setReconfigurableUnit(this);
        this.viewer.repaint();
    }

    public String getImagePath() {
        return "cb_rlu.png";
    }
}

