/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.rlu;

import java.io.InputStream;
import java.io.OutputStream;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import org.w3c.dom.Node;

public class ExternalDataInterface
extends MicsElement
implements DataBuffer,
ChannelConnectable {
    private String busID;
    private int addr;
    DataBuffer input;
    private Channel busInstance = null;
    MicsDataPacket buffer;

    public ExternalDataInterface() {
    }

    ExternalDataInterface(Channel bus, int addr, DataBuffer src) {
        this.busInstance = bus;
        this.addr = addr;
        this.input = src;
    }

    public String[] getConnectedElements() {
        return null;
    }

    public String getImagePath() {
        return null;
    }

    private Channel bus() throws MicsException {
        if (this.busInstance == null) {
            this.busInstance = this.composite.getChannel(this.busID);
        }
        return this.busInstance;
    }

    public void initialize(String base, Node node) throws MicsException {
    }

    public void reset() {
    }

    public void dump(int offset, int len, OutputStream writer) throws DataBufferException {
    }

    public void writeback(MicsDataPacket data) throws MicsException {
        this.buffer = data;
    }

    public MicsDataPacket read(MicsDataPacket data) throws MicsException {
        RandomAccessMemoryDataPacket p = (RandomAccessMemoryDataPacket)data;
        switch (p.addr) {
            case 0: {
                this.bus().readRequest(this, RandomAccessMemoryDataPacket.readPacket(this.addr, 1, 16));
                return this.buffer;
            }
            case 2: {
                this.bus().readRequest(this, RandomAccessMemoryDataPacket.readPacket(this.addr + 2, 1, 16));
                return this.buffer;
            }
            case 4: {
                this.bus().readRequest(this, RandomAccessMemoryDataPacket.readPacket(this.addr, 1, 16));
                return this.buffer;
            }
        }
        throw new MicsException("Illegal Address");
    }

    public int size() {
        return 0;
    }

    public String toString(int addr, int length) {
        return null;
    }

    public void write(MicsDataPacket data) {
    }

    public void write(int offset, InputStream reader) throws DataBufferException {
    }

    public int getChannelOffset(Channel c) {
        return 0;
    }
}

