/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.gdb;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wasamon.jgdb.GDBClient;
import net.wasamon.jgdb.GDBMIInterface;
import net.wasamon.jgdb.GDBXMLClient;
import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.ExecutableElementException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;
import net.wasamon.mics.processor.gdb.InstInfo;
import net.wasamon.mics.processor.gdb.SHInstList;
import net.wasamon.mics.util.ChannelManager;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;
import org.w3c.dom.Node;

public class SH3
extends MicsElement
implements ExecutableElement,
ChannelConnectable {
    private GDBClient gdb;
    private ChannelManager channelManager;
    String destRegister;
    int destWidth;
    private boolean terminatedFlag;
    private String targetFilePath;
    private String targetGdbPath;
    private String targetGdbHostName;
    private int targetGdbPort;
    private OperationCode lastCode;

    private void memoryHook(OperationCode op) throws ExecutableElementException {
        if (op.operand[0].type == 1 && op.operand[1].type == 2) {
            int src = DataUtil.parseInt(this.gdb.readRegister(op.operand[0].value));
            int destAddr = op.getAccessAddress(1);
            ChannelManager.Element c = this.channelManager.search(destAddr);
            try {
                MicsDataPacket p = null;
                byte[] b = DataUtil.toByteArray(src);
                switch (op.width) {
                    case 1: {
                        p = RandomAccessMemoryDataPacket.writePacket(destAddr - c.offset, 1, 8, new byte[]{b[3]});
                        break;
                    }
                    case 2: {
                        p = RandomAccessMemoryDataPacket.writePacket(destAddr - c.offset, 1, 16, new byte[]{b[2], b[3]});
                        break;
                    }
                    case 4: {
                        p = RandomAccessMemoryDataPacket.writePacket(destAddr - c.offset, 2, 16, b);
                    }
                }
                c.getChannel().writeRequest(this, p);
            }
            catch (MicsException e) {
                System.out.println("SH3 memory hook exception: " + e.getMessage());
                throw new ExecutableElementException(e);
            }
        } else if (op.operand[0].type == 2 && op.operand[1].type == 1) {
            this.destRegister = op.operand[1].value;
            this.destWidth = op.width;
            int srcAddr = op.preOperandValue[0];
            ChannelManager.Element c = this.channelManager.search(srcAddr);
            try {
                MicsDataPacket p = null;
                p = RandomAccessMemoryDataPacket.readPacket(srcAddr - c.offset, op.width, 8);
                c.getChannel().readRequest(this, p);
            }
            catch (MicsException e) {
                throw new ExecutableElementException(e);
            }
        } else {
            System.out.println("unsupported data transfer instruction:" + op);
        }
    }

    public void writeback(MicsDataPacket d) {
        RandomAccessMemoryDataPacket r = (RandomAccessMemoryDataPacket)d;
        this.gdb.setValueToRegister("$" + this.destRegister, DataUtil.toBigEndianValueString(r.data));
    }

    public int getChannelOffset(Channel c) {
        return this.channelManager.search(c);
    }

    public ExecInfo exec_first() throws ExecutableElementException {
        ExecInfo status = new ExecInfo();
        if (this.terminatedFlag) {
            status.setTerminatableFlag(true);
        } else {
            try {
                String code = this.gdb.readPCCode();
                String[] tmp = code.split(":\\s+");
                OperationCode op = new OperationCode(tmp[1]);
                this.gdb.stepInstruction();
                this.lastCode = op;
                status.setCycle(this.lastCode.info.getState());
                if (this.gdb.isStopped()) {
                    if (this.gdb.getSignal() != null) {
                        String signal = this.gdb.getSignal();
                        if (signal.startsWith("SIGBUS") || signal.startsWith("SIGEMT")) {
                            this.memoryHook(op);
                        } else {
                            System.out.println("signal:" + signal);
                        }
                        this.gdb.setValueToRegister("$pc", "$pc+2");
                    } else {
                        this.terminatedFlag = true;
                        status.setTerminatableFlag(true);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ExecutableElementException(e);
            }
        }
        return status;
    }

    public ExecInfo exec_second() throws ExecutableElementException {
        ExecInfo status = new ExecInfo();
        return status;
    }

    public void reset() {
        if (this.gdb != null) {
            this.gdb.doInit(new File(this.targetFilePath), "main");
        }
        this.terminatedFlag = false;
    }

    public void init(String type, String targetFilePath, String gdbPath) throws MicsException {
        block4: {
            this.targetGdbPath = gdbPath;
            this.targetFilePath = targetFilePath;
            try {
                if (type.equals("local")) {
                    this.gdb = new GDBMIInterface(gdbPath);
                    break block4;
                }
                if (type.equals("xmlrpc")) {
                    this.gdb = new GDBXMLClient(gdbPath);
                    break block4;
                }
                throw new MicsException("illetal type value: " + type);
            }
            catch (IOException e) {
                throw new MicsException("cannot initialize net.wasamon.mics.processor.gdb.SH3");
            }
        }
        this.gdb.doInit(new File(targetFilePath), "main");
    }

    public void initialize(String base, Node n) throws MicsException {
        this.channelManager = new ChannelManager(this.composite);
        try {
            Node init_var_node = n;
            String init_var_target = XMLParser.getAttribute(init_var_node, "target").getNodeValue();
            String init_var_gdb = XMLParser.getAttribute(init_var_node, "gdb").getNodeValue();
            String init_var_type = XMLParser.getAttribute(init_var_node, "type").getNodeValue();
            this.init(init_var_type, init_var_target, init_var_gdb);
            Node[] init_var__channel_obj = XMLParser.getNamedNodeArray(n, "channel");
            int i = 0;
            while (i < init_var__channel_obj.length) {
                Node init_var__channel_node = init_var__channel_obj[i];
                String init_var__channel_id = XMLParser.getAttribute(init_var__channel_node, "id").getNodeValue();
                int init_var__channel_offset = DataUtil.parseInt(XMLParser.getAttribute(init_var__channel_node, "offset").getNodeValue());
                this.channelManager.add(init_var__channel_id, init_var__channel_offset);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.gdb");
        }
        catch (XMLParserException e) {
            throw new MicsException("configuration syntax error: net.wasamon.mics.processor.gdb");
        }
    }

    public void execStepCode() throws Exception {
        String code = this.gdb.readPCCode();
        String[] tmp = code.split(":\\s+");
        OperationCode op = new OperationCode(tmp[1]);
        this.memoryHook(op);
        this.gdb.stepInstruction();
        this.memoryHook(op);
        this.lastCode = op;
    }

    public void execAll() {
        Calendar cal = Calendar.getInstance();
        System.out.println("start execution at " + cal.getTime());
        long start_time = cal.getTimeInMillis();
        int count = 0;
        try {
            do {
                this.execStepCode();
                ++count;
            } while (!this.gdb.isStopped());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cal = Calendar.getInstance();
        System.out.println("stop execution at " + cal.getTime());
        long time_span = cal.getTimeInMillis() - start_time;
        System.out.print("exec cycles: " + count);
        if (time_span > 0L) {
            System.out.println(" C/S: " + (double)count / (double)time_span + "kHz");
        } else {
            System.out.println("");
        }
    }

    public void shutdown() {
        this.gdb.doQuit();
    }

    public static void main(String[] args) throws Exception {
        SH3 proc = new SH3();
        proc.init("local", "l:\\a.out", "sh-hitachi-elf-gdb");
        proc.execAll();
        proc.shutdown();
    }

    public String[] getConnectedElements() {
        return this.channelManager.getConnectedElements();
    }

    public String getInfo() {
        String str = "";
        str = String.valueOf(str) + "id: " + super.id() + "\n";
        str = String.valueOf(str) + "class: " + this.getClass().getName() + "\n";
        str = String.valueOf(str) + "gdb: " + this.targetGdbPath + "\n";
        str = String.valueOf(str) + "host: " + this.targetGdbHostName + "\n";
        str = String.valueOf(str) + "port: " + this.targetGdbPort + "\n";
        str = String.valueOf(str) + "target: " + this.targetFilePath + "\n";
        ChannelManager.Element[] channels = this.channelManager.array();
        int i = 0;
        while (i < channels.length) {
            ChannelManager.Element element = channels[i];
            str = String.valueOf(str) + "  Channel ID: " + element.id + ",";
            str = String.valueOf(str) + " offset = " + element.offset + "\n";
            ++i;
        }
        return str;
    }

    public String toString() {
        return String.valueOf(this.getInfo()) + this.lastCode.toString();
    }

    public String getImagePath() {
        return "superh.png";
    }

    class OperationCode {
        String op_name;
        InstInfo info;
        Operand[] operand;
        int[] preOperandValue;
        int width;
        private Pattern codePattern = Pattern.compile("(\\S+)\\s*(.*)\\s*");
        private Pattern dispRegPattern = Pattern.compile("@\\((\\d+),(.+)\\)");

        public int getOperandWidth(String name) {
            int len = this.op_name.indexOf(".W") > 0 ? 2 : (this.op_name.indexOf(".L") > 0 ? 4 : (this.op_name.indexOf(".B") > 0 ? 1 : 2));
            return len;
        }

        public OperationCode(String code) throws Exception {
            Matcher m = this.codePattern.matcher(code);
            if (!m.matches()) {
                throw new Exception("syntax error");
            }
            this.op_name = m.group(1).toUpperCase();
            this.width = this.getOperandWidth(this.op_name);
            this.operand = this.parseOperand(m.group(2));
            this.info = SHInstList.getInstance().getInstInfo(this.op_name, this.getType());
            this.preOperandValue = new int[this.operand.length];
            int i = 0;
            while (i < this.operand.length) {
                if (this.operand[i].type == 2) {
                    this.preOperandValue[i] = this.getAccessAddress(i);
                }
                ++i;
            }
        }

        private int[] getType() {
            int[] t = new int[this.operand.length];
            int i = 0;
            while (i < t.length) {
                t[i] = this.operand[i].type;
                ++i;
            }
            return t;
        }

        private Operand[] parseOperand(String o) {
            Operand[] operands = null;
            if (o.equals("")) {
                operands = new Operand[]{};
            } else {
                String[] tmp = o.split(",");
                String[] op_value = new String[tmp.length];
                int op_index = 0;
                int i = 0;
                while (i < tmp.length) {
                    if (tmp[i].indexOf(40) > 0) {
                        op_value[op_index] = String.valueOf(tmp[i]) + "," + tmp[i + 1];
                        ++i;
                    } else {
                        op_value[op_index] = tmp[i];
                    }
                    ++i;
                    ++op_index;
                }
                operands = new Operand[op_index];
                i = 0;
                while (i < operands.length) {
                    operands[i] = new Operand(InstInfo.getOpType(op_value[i]), op_value[i]);
                    ++i;
                }
            }
            return operands;
        }

        public String toString() {
            String str = "";
            str = String.valueOf(str) + "[OperationCode] " + this.op_name;
            int i = 0;
            while (i < this.operand.length) {
                str = String.valueOf(str) + " " + this.operand[i];
                ++i;
            }
            return str;
        }

        public int getOperandSize() {
            return this.operand.length;
        }

        public int getAccessAddress(int index) {
            String val = this.operand[index].value;
            String r = null;
            if (val.startsWith("@r")) {
                if (val.endsWith("+")) {
                    r = SH3.this.gdb.readRegister(val.substring(1, val.length() - 1));
                    return DataUtil.parseInt(r);
                }
                r = SH3.this.gdb.readRegister(val.substring(1));
                return DataUtil.parseInt(r);
            }
            if (val.startsWith("@-r")) {
                r = SH3.this.gdb.readRegister(val.substring(2));
                return DataUtil.parseInt(r);
            }
            if (val.startsWith("@(r0,")) {
                String tmp = val.substring(2, val.length() - 1);
                String[] regs = tmp.split(",");
                String r0 = SH3.this.gdb.readRegister(regs[0]);
                String r1 = SH3.this.gdb.readRegister(regs[1]);
                return DataUtil.parseInt(r0) + DataUtil.parseInt(r1);
            }
            if (val.startsWith("@")) {
                Matcher m = this.dispRegPattern.matcher(val);
                if (m.matches()) {
                    int disp = DataUtil.parseInt(m.group(1));
                    r = SH3.this.gdb.readRegister(m.group(2));
                    return DataUtil.parseInt(r) + disp;
                }
                System.out.println("unsupported access: " + val);
                return 0;
            }
            if (val.charAt(0) == '0') {
                String[] tmp = val.split("\\s+");
                return DataUtil.parseInt(tmp[0]);
            }
            System.out.println("unsupported access: " + val);
            return 0;
        }

        class Operand {
            int type;
            String value;

            public Operand(int type, String value) {
                this.type = type;
                this.value = value;
            }

            public String toString() {
                return String.valueOf(this.value) + "%" + InstInfo.getOpTypeString(this.type);
            }
        }
    }
}

