/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mics.processor.gdb;

class InstInfo {
    public static final int no_op = -1;
    public static final int imm = 0;
    public static final int reg = 1;
    public static final int value = 2;
    public static final int label = 2;
    public static final int pr = 4;
    String name;
    int[] operand;
    int state;
    int stage;
    int state_dsp;
    int stage_dsp;
    boolean dsp_modifier = false;

    InstInfo(String name, int[] operand, int state, int stage) {
        this.name = name;
        this.operand = operand;
        this.state = state;
        this.stage = stage;
    }

    InstInfo(String name, int[] operand, int state, int state_dsp, int stage, int stage_dsp) {
        this(name, operand, state, stage);
        this.dsp_modifier = true;
        this.state_dsp = state_dsp;
        this.stage_dsp = stage_dsp;
    }

    public int getState() {
        return this.state;
    }

    public int getStage() {
        return this.stage;
    }

    public boolean equals(String name, int[] operand) {
        if (!this.name.equals(name)) {
            return false;
        }
        if (operand.length != this.operand.length) {
            return false;
        }
        int i = 0;
        while (i < operand.length) {
            if (operand[i] != this.operand[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + this.name + ":";
        String tmp = "";
        int i = 0;
        while (i < this.operand.length) {
            tmp = String.valueOf(tmp) + "," + InstInfo.getOpTypeString(this.operand[i]);
            ++i;
        }
        if (tmp.length() > 1) {
            str = String.valueOf(str) + tmp.substring(1);
        }
        str = String.valueOf(str) + "  [";
        str = String.valueOf(str) + "states = " + this.state;
        if (this.state_dsp > 0) {
            str = String.valueOf(str) + "(" + this.state_dsp + ")";
        }
        str = String.valueOf(str) + ",stages = " + this.stage;
        if (this.state_dsp > 0) {
            str = String.valueOf(str) + "(" + this.stage_dsp + ")";
        }
        str = String.valueOf(str) + "]";
        return str;
    }

    public static String getOpTypeString(int type) {
        switch (type) {
            case -1: {
                return "none";
            }
            case 0: {
                return "imm";
            }
            case 1: {
                return "reg";
            }
            case 2: {
                return "value";
            }
            case 4: {
                return "pr";
            }
        }
        return "unknown";
    }

    public static int getOpType(String op) {
        if (op == null || op.equals("")) {
            return -1;
        }
        if (op.charAt(0) == '#') {
            return 0;
        }
        if (op.charAt(0) == 'r') {
            return 1;
        }
        if (op.charAt(0) == '@') {
            return 2;
        }
        if (op.charAt(0) == '0') {
            return 2;
        }
        if (op.toLowerCase().equals("pr")) {
            return 4;
        }
        return -1;
    }
}

